/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.Map;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;

public class PluginInfoHandler
extends RequestHandlerBase {
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        boolean stats = params.getBool("stats", false);
        rsp.add("plugins", PluginInfoHandler.getSolrInfoBeans(req.getCore(), stats));
        rsp.setHttpCaching(false);
    }

    private static SimpleOrderedMap<Object> getSolrInfoBeans(SolrCore core, boolean stats) {
        SimpleOrderedMap list = new SimpleOrderedMap();
        for (SolrInfoBean.Category cat : SolrInfoBean.Category.values()) {
            SimpleOrderedMap category = new SimpleOrderedMap();
            list.add(cat.name(), (Object)category);
            Map<String, SolrInfoBean> reg = core.getInfoRegistry();
            for (Map.Entry<String, SolrInfoBean> entry : reg.entrySet()) {
                SolrInfoBean m = entry.getValue();
                if (m.getCategory() != cat) continue;
                String na = "Not Declared";
                SimpleOrderedMap info = new SimpleOrderedMap();
                category.add(entry.getKey(), (Object)info);
                info.add("name", (Object)(m.getName() != null ? m.getName() : na));
                info.add("description", (Object)(m.getDescription() != null ? m.getDescription() : na));
                if (!stats || m.getSolrMetricsContext() == null) continue;
                info.add("stats", m.getSolrMetricsContext().getMetricsSnapshot());
            }
        }
        return list;
    }

    @Override
    public String getDescription() {
        return "Registry";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.METRICS_READ_PERM;
    }
}

