/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.client.api.endpoint.MergeIndexesApi;
import org.apache.solr.client.api.model.MergeIndexesRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CachingDirectoryFactory;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.api.CoreAdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeIndexes
extends CoreAdminAPIBase
implements MergeIndexesApi {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Inject
    public MergeIndexes(CoreContainer coreContainer, CoreAdminHandler.CoreAdminAsyncTracker coreAdminAsyncTracker, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(coreContainer, coreAdminAsyncTracker, req, rsp);
    }

    @Override
    public boolean isExpensive() {
        return true;
    }

    @PermissionName(value=PermissionNameProvider.Name.CORE_EDIT_PERM)
    public SolrJerseyResponse mergeIndexes(String coreName, MergeIndexesRequestBody requestBody) throws Exception {
        this.ensureRequiredParameterProvided("coreName", coreName);
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        return this.handlePotentiallyAsynchronousTask(response, coreName, requestBody.async, "merge-indices", () -> {
            try {
                SolrCore core = this.coreContainer.getCore(coreName);
                SolrQueryRequest wrappedReq = null;
                if (core == null) {
                    return response;
                }
                ArrayList sourceCores = new ArrayList();
                ArrayList<RefCounted<SolrIndexSearcher>> searchers = new ArrayList<RefCounted<SolrIndexSearcher>>();
                ArrayList<DirectoryReader> readersToBeClosed = new ArrayList<DirectoryReader>();
                HashMap dirsToBeReleased = new HashMap();
                try {
                    Iterator dirNames = Optional.ofNullable(requestBody.indexDirs).orElseGet(() -> new ArrayList());
                    if (dirNames.isEmpty()) {
                        List sources = Optional.ofNullable(requestBody.srcCores).orElseGet(() -> new ArrayList());
                        if (sources.isEmpty()) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "At least one indexDir or srcCore must be specified");
                        }
                        sources.stream().forEach(src -> {
                            String source = src;
                            SolrCore srcCore = this.coreContainer.getCore(source);
                            if (srcCore == null) {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core: " + source + " does not exist");
                            }
                            sourceCores.add(srcCore);
                        });
                    } else {
                        dirNames.stream().forEach(indexDir -> core.getCoreContainer().assertPathAllowed(Paths.get(indexDir, new String[0])));
                        DirectoryFactory dirFactory = core.getDirectoryFactory();
                        dirNames.stream().forEach(dir -> {
                            boolean markAsDone = false;
                            if (dirFactory instanceof CachingDirectoryFactory && !((CachingDirectoryFactory)dirFactory).getLivePaths().contains(dir)) {
                                markAsDone = true;
                            }
                            try {
                                Directory dirTemp = dirFactory.get((String)dir, DirectoryFactory.DirContext.DEFAULT, core.getSolrConfig().indexConfig.lockType);
                                dirsToBeReleased.put(dirTemp, markAsDone);
                                readersToBeClosed.add(DirectoryReader.open((Directory)dirTemp));
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                    ArrayList<DirectoryReader> readers = null;
                    if (readersToBeClosed.size() > 0) {
                        readers = readersToBeClosed;
                    } else {
                        readers = new ArrayList();
                        for (SolrCore solrCore : sourceCores) {
                            RefCounted<SolrIndexSearcher> searcher = solrCore.getSearcher();
                            searchers.add(searcher);
                            readers.add(searcher.get().getRawReader());
                        }
                    }
                    UpdateRequestProcessorChain processorChain = core.getUpdateProcessingChain(requestBody.updateChain);
                    wrappedReq = new LocalSolrQueryRequest(core, this.req.getParams());
                    UpdateRequestProcessor processor = processorChain.createProcessor(wrappedReq, this.rsp);
                    processor.processMergeIndexes(new MergeIndexesCommand(readers, this.req));
                }
                catch (Exception e) {
                    log.error("ERROR executing merge:", (Throwable)e);
                    throw e;
                }
                finally {
                    for (RefCounted refCounted : searchers) {
                        if (refCounted == null) continue;
                        refCounted.decref();
                    }
                    for (SolrCore solrCore : sourceCores) {
                        if (solrCore == null) continue;
                        solrCore.close();
                    }
                    IOUtils.closeWhileHandlingException(readersToBeClosed);
                    Set entries = dirsToBeReleased.entrySet();
                    for (Map.Entry entry : entries) {
                        DirectoryFactory dirFactory = core.getDirectoryFactory();
                        Directory dir2 = (Directory)entry.getKey();
                        boolean markAsDone = (Boolean)entry.getValue();
                        if (markAsDone) {
                            dirFactory.doneWithDirectory(dir2);
                        }
                        dirFactory.release(dir2);
                    }
                    if (wrappedReq != null) {
                        wrappedReq.close();
                    }
                    core.close();
                }
                return response;
            }
            catch (SolrException exp) {
                throw exp;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to Merge Indexes=" + coreName + " because " + String.valueOf(e), (Throwable)e);
            }
        });
    }
}

