/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Rescorer;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.ReRankOperator;
import org.apache.solr.search.ReRankScaler;

public class ReRankWeight
extends FilterWeight {
    private final IndexSearcher searcher;
    private final Rescorer reRankQueryRescorer;
    private final ReRankScaler reRankScaler;
    private final ReRankOperator reRankOperator;

    public ReRankWeight(Query mainQuery, Rescorer reRankQueryRescorer, IndexSearcher searcher, Weight mainWeight, ReRankScaler reRankScaler, ReRankOperator reRankOperator) throws IOException {
        super(mainQuery, mainWeight);
        this.searcher = searcher;
        this.reRankQueryRescorer = reRankQueryRescorer;
        this.reRankScaler = reRankScaler;
        this.reRankOperator = reRankOperator;
    }

    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        Explanation mainExplain = this.in.explain(context, doc);
        Explanation reRankExplain = this.reRankQueryRescorer.explain(this.searcher, mainExplain, context.docBase + doc);
        if (this.reRankScaler != null && this.reRankScaler.scaleScores()) {
            Explanation reScaleExplain = this.reRankScaler.explain(context.docBase + doc, mainExplain, reRankExplain);
            if (reScaleExplain != null) {
                return reScaleExplain;
            }
            return reRankExplain;
        }
        return reRankExplain;
    }
}

