/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.JoinUtil;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.join.ScoreModeParser;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScoreJoinQParserPlugin
extends QParserPlugin {
    public static final String USE_CROSSCOLLECTION = "SolrCloud join: To join with a collection that might not be co-located, use method=crossCollection.";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SCORE = "score";
    public static final String CHECK_ROUTER_FIELD = "checkRouterField";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){

            @Override
            public Query parse() throws SyntaxError {
                String fromField = this.localParams.get("from");
                String fromIndex = this.localParams.get("fromIndex");
                String toField = this.localParams.get("to");
                ScoreMode scoreMode = ScoreModeParser.parse(this.getParam(ScoreJoinQParserPlugin.SCORE));
                String v = this.localParams.get("v");
                return this.createQuery(fromField, v, fromIndex, toField, scoreMode, CommonParams.TRUE.equals(this.localParams.get("TESTenforceSameCoreAsAnotherOne")));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Query createQuery(String fromField, String fromQueryStr, String fromIndex, String toField, ScoreMode scoreMode, boolean byPassShortCircutCheck) throws SyntaxError {
                String myCore = this.req.getCore().getCoreDescriptor().getName();
                if (fromIndex != null && (!fromIndex.equals(myCore) || byPassShortCircutCheck)) {
                    CoreContainer container = this.req.getCoreContainer();
                    String coreName = ScoreJoinQParserPlugin.getCoreName(fromIndex, container, this.req.getCore(), toField, fromField, this.localParams);
                    SolrCore fromCore = container.getCore(coreName);
                    RefCounted<SolrIndexSearcher> fromHolder = null;
                    if (fromCore == null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core join: no such core " + coreName);
                    }
                    long fromCoreOpenTime = 0L;
                    LocalSolrQueryRequest otherReq = new LocalSolrQueryRequest(fromCore, this.params);
                    try {
                        QParser fromQueryParser = QParser.getParser(fromQueryStr, otherReq);
                        Query fromQuery = fromQueryParser.getQuery();
                        fromHolder = fromCore.getRegisteredSearcher();
                        if (fromHolder != null) {
                            fromCoreOpenTime = fromHolder.get().getOpenNanoTime();
                        }
                        OtherCoreJoinQuery otherCoreJoinQuery = new OtherCoreJoinQuery(fromQuery, fromField, coreName, fromCoreOpenTime, scoreMode, toField);
                        return otherCoreJoinQuery;
                    }
                    finally {
                        otherReq.close();
                        fromCore.close();
                        if (fromHolder != null) {
                            fromHolder.decref();
                        }
                    }
                }
                QParser fromQueryParser = this.subQuery(fromQueryStr, null);
                Query fromQuery = fromQueryParser.getQuery();
                return new SameCoreJoinQuery(fromQuery, fromField, toField, scoreMode);
            }
        };
    }

    public static String getCoreName(String fromIndex, CoreContainer container, SolrCore toCore, String toField, String fromField, SolrParams localParams) {
        if (container.isZooKeeperAware()) {
            ZkController zkController = container.getZkController();
            String fromCollection = ScoreJoinQParserPlugin.resolveAlias(fromIndex, zkController);
            if (!zkController.getClusterState().hasCollection(fromCollection)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "SolrCloud join: Collection '" + fromIndex + "' not found!");
            }
            return ScoreJoinQParserPlugin.findLocalReplicaForFromIndex(zkController, fromCollection, toCore, toField, fromField, localParams);
        }
        return fromIndex;
    }

    public static Query createJoinQuery(Query subQuery, String fromField, String toField, ScoreMode scoreMode) {
        return new SameCoreJoinQuery(subQuery, fromField, toField, scoreMode);
    }

    private static String resolveAlias(String fromIndex, ZkController zkController) {
        Aliases aliases = zkController.getZkStateReader().getAliases();
        try {
            return aliases.resolveSimpleAlias(fromIndex);
        }
        catch (IllegalArgumentException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "SolrCloud join: Collection alias '" + fromIndex + "' maps to multiple collectiions, which is not currently supported for joins.", (Throwable)e);
        }
    }

    private static String findLocalReplicaForFromIndex(ZkController zkController, String fromIndex, SolrCore toCore, String toField, String fromField, SolrParams localParams) {
        DocCollection fromCollection = zkController.getClusterState().getCollection(fromIndex);
        String nodeName = zkController.getNodeName();
        if (fromCollection.getSlices().size() == 1) {
            return ScoreJoinQParserPlugin.getLocalSingleShard(zkController, fromIndex);
        }
        CloudDescriptor toCoreDescriptor = toCore.getCoreDescriptor().getCloudDescriptor();
        DocCollection toCollection = zkController.getClusterState().getCollection(toCoreDescriptor.getCollectionName());
        String shardId = toCoreDescriptor.getShardId();
        boolean isFromSideCheckRequired = ScoreJoinQParserPlugin.checkToSideRouter(toCore, toField, localParams, fromCollection, toCollection);
        ScoreJoinQParserPlugin.checkSliceRanges(toCollection, fromCollection, shardId);
        return ScoreJoinQParserPlugin.findCollocatedFromCore(toCore, fromField, fromCollection, nodeName, isFromSideCheckRequired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findCollocatedFromCore(SolrCore toCore, String fromField, DocCollection fromCollection, String nodeName, boolean isFromSideCheckRequired) {
        CloudDescriptor toCoreDescriptor = toCore.getCoreDescriptor().getCloudDescriptor();
        String toShardId = toCoreDescriptor.getShardId();
        Slice fromShardReplicas = (Slice)fromCollection.getActiveSlicesMap().get(toShardId);
        Iterator iterator = fromShardReplicas.getReplicas(r -> r.getNodeName().equals(nodeName)).iterator();
        if (iterator.hasNext()) {
            Replica collocatedFrom = (Replica)iterator.next();
            String fromCore = collocatedFrom.getCoreName();
            if (log.isDebugEnabled()) {
                log.debug("<-{} @ {}", (Object)fromCore, (Object)toCoreDescriptor.getCoreNodeName());
            }
            if (isFromSideCheckRequired) {
                SolrCore[] fromCoreOnDemand = new SolrCore[1];
                try {
                    ScoreJoinQParserPlugin.checkRouterField(() -> fromCoreOnDemand[0] == null ? toCore.getCoreContainer().getCore(fromCore) : fromCoreOnDemand[0], fromCollection, fromField);
                }
                finally {
                    if (fromCoreOnDemand[0] != null) {
                        fromCoreOnDemand[0].close();
                    }
                }
            }
            return fromCore;
        }
        String shards = fromShardReplicas.getReplicas().stream().map(r -> r.getShard() + ":" + r.getCoreName() + "@" + r.getNodeName()).collect(Collectors.joining(","));
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to find collocated \"from\" replica: " + shards + " at node: " + nodeName + " for " + toShardId + ". SolrCloud join: To join with a collection that might not be co-located, use method=crossCollection.");
    }

    private static boolean checkToSideRouter(SolrCore toCore, String toField, SolrParams localParams, DocCollection fromCollection, DocCollection toCollection) {
        String routerName = ScoreJoinQParserPlugin.checkRouters(toCollection, fromCollection);
        boolean checkFromRouterField = false;
        switch (routerName) {
            case "plain": {
                checkFromRouterField = true;
                ScoreJoinQParserPlugin.checkRouterField(() -> toCore, toCollection, toField);
                break;
            }
            case "compositeId": {
                if (!localParams.getBool(CHECK_ROUTER_FIELD, true)) break;
                checkFromRouterField = true;
                ScoreJoinQParserPlugin.checkRouterField(() -> toCore, toCollection, toField);
                break;
            }
            default: {
                if (!localParams.getBool(CHECK_ROUTER_FIELD, true)) break;
                ScoreJoinQParserPlugin.checkRouterField(() -> toCore, toCollection, toField);
            }
        }
        return checkFromRouterField;
    }

    private static String getLocalSingleShard(ZkController zkController, String fromIndex) {
        DocCollection fromCollection = zkController.getClusterState().getCollection(fromIndex);
        String nodeName = zkController.getNodeName();
        String fromReplica = null;
        block0: for (Slice slice : fromCollection.getActiveSlicesArr()) {
            assert (fromReplica == null);
            for (Replica replica : slice.getReplicas()) {
                if (!replica.getNodeName().equals(nodeName)) continue;
                fromReplica = replica.getStr("core");
                if (replica.getState() == Replica.State.ACTIVE) continue block0;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "SolrCloud join: " + fromIndex + " has a local replica (" + fromReplica + ") on " + nodeName + ", but it is " + String.valueOf(replica.getState()));
            }
        }
        if (fromReplica == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, USE_CROSSCOLLECTION);
        }
        return fromReplica;
    }

    private static void checkSliceRanges(DocCollection toCollection, DocCollection fromCollection, String shardId) {
        DocRouter.Range toRange = toCollection.getSlice(shardId).getRange();
        DocRouter.Range fromRange = fromCollection.getSlice(shardId).getRange();
        if (toRange == null && fromRange == null) {
            return;
        }
        if (toRange == null != (fromRange == null)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expecting non null slice ranges for shard:" + shardId + " of " + String.valueOf(toCollection) + " " + String.valueOf(toRange) + " and " + String.valueOf(fromCollection) + " " + String.valueOf(fromRange) + ". SolrCloud join: To join with a collection that might not be co-located, use method=crossCollection.");
        }
        if (!toRange.isSubsetOf(fromRange)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expecting hash range of collection:" + toCollection.getName() + " of shard:" + shardId + " " + String.valueOf(toRange) + " to be a subset of the same shard of collection:" + fromCollection.getName() + ", which is " + String.valueOf(fromRange) + ". SolrCloud join: To join with a collection that might not be co-located, use method=crossCollection.");
        }
    }

    private static void checkRouterField(Supplier<SolrCore> toCore, DocCollection fromCollection, String fromField) {
        String routeField = fromCollection.getRouter().getRouteField(fromCollection);
        if (routeField == null) {
            routeField = toCore.get().getLatestSchema().getUniqueKeyField().getName();
        }
        if (!fromField.equals(routeField)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "collection:" + fromCollection.getName() + " is sharded by: '" + routeField + "', but attempting to join via '" + fromField + "' field. SolrCloud join: To join with a collection that might not be co-located, use method=crossCollection.");
        }
    }

    private static String checkRouters(DocCollection collection, DocCollection fromCollection) {
        String routerName = collection.getRouter().getName();
        if (!routerName.equals(fromCollection.getRouter().getName())) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, collection.getName() + " and " + fromCollection.getName() + " should have the same routers, but they are: " + collection.getRouter().getName() + " and " + fromCollection.getRouter().getName() + ". SolrCloud join: To join with a collection that might not be co-located, use method=crossCollection.");
        }
        return routerName;
    }

    static class SameCoreJoinQuery
    extends Query {
        protected final Query fromQuery;
        protected final ScoreMode scoreMode;
        protected final String fromField;
        protected final String toField;

        SameCoreJoinQuery(Query fromQuery, String fromField, String toField, ScoreMode scoreMode) {
            this.fromQuery = fromQuery;
            this.scoreMode = scoreMode;
            this.fromField = fromField;
            this.toField = toField;
        }

        public Weight createWeight(IndexSearcher searcher, org.apache.lucene.search.ScoreMode scoreMode, float boost) throws IOException {
            SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
            Query jq = JoinUtil.createJoinQuery((String)this.fromField, (boolean)true, (String)this.toField, (Query)this.fromQuery, (IndexSearcher)info.getReq().getSearcher(), (ScoreMode)this.scoreMode);
            return jq.rewrite(searcher.getIndexReader()).createWeight(searcher, scoreMode, boost);
        }

        public String toString(String field) {
            return "SameCoreJoinQuery [fromQuery=" + String.valueOf(this.fromQuery) + ", fromField=" + this.fromField + ", toField=" + this.toField + ", scoreMode=" + String.valueOf(this.scoreMode) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = this.classHash();
            result = 31 * result + Objects.hashCode(this.fromField);
            result = 31 * result + Objects.hashCode(this.fromQuery);
            result = 31 * result + Objects.hashCode(this.scoreMode);
            result = 31 * result + Objects.hashCode(this.toField);
            return result;
        }

        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((SameCoreJoinQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
        }

        private boolean equalsTo(SameCoreJoinQuery other) {
            return Objects.equals(this.fromField, other.fromField) && Objects.equals(this.fromQuery, other.fromQuery) && Objects.equals(this.scoreMode, other.scoreMode) && Objects.equals(this.toField, other.toField);
        }

        public void visit(QueryVisitor visitor) {
            visitor.visitLeaf((Query)this);
        }
    }

    static class OtherCoreJoinQuery
    extends SameCoreJoinQuery {
        private final String fromIndex;
        private final long fromCoreOpenTime;

        public OtherCoreJoinQuery(Query fromQuery, String fromField, String fromIndex, long fromCoreOpenTime, ScoreMode scoreMode, String toField) {
            super(fromQuery, fromField, toField, scoreMode);
            this.fromIndex = fromIndex;
            this.fromCoreOpenTime = fromCoreOpenTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Weight createWeight(IndexSearcher searcher, org.apache.lucene.search.ScoreMode scoreMode, float boost) throws IOException {
            Query joinQuery;
            SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
            CoreContainer container = info.getReq().getCoreContainer();
            SolrCore fromCore = container.getCore(this.fromIndex);
            if (fromCore == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core join: no such core " + this.fromIndex);
            }
            RefCounted<SolrIndexSearcher> fromHolder = fromCore.getRegisteredSearcher();
            try {
                joinQuery = JoinUtil.createJoinQuery((String)this.fromField, (boolean)true, (String)this.toField, (Query)this.fromQuery, (IndexSearcher)fromHolder.get(), (ScoreMode)this.scoreMode);
            }
            finally {
                fromCore.close();
                fromHolder.decref();
            }
            return joinQuery.rewrite(searcher.getIndexReader()).createWeight(searcher, scoreMode, boost);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.fromCoreOpenTime ^ this.fromCoreOpenTime >>> 32);
            result = 31 * result + (this.fromIndex == null ? 0 : this.fromIndex.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof OtherCoreJoinQuery)) {
                return false;
            }
            OtherCoreJoinQuery other = (OtherCoreJoinQuery)((Object)obj);
            return this.fromCoreOpenTime == other.fromCoreOpenTime && Objects.equals(this.fromIndex, other.fromIndex);
        }

        @Override
        public String toString(String field) {
            return "OtherCoreJoinQuery [fromIndex=" + this.fromIndex + ", fromCoreOpenTime=" + this.fromCoreOpenTime + " extends " + super.toString(field) + "]";
        }
    }
}

