/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.mlt;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.legacy.LegacyNumericUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.mlt.AbstractMLTQParser;

public class SimpleMLTQParser
extends AbstractMLTQParser {
    public SimpleMLTQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() {
        String uniqueValue = this.localParams.get("v");
        SolrIndexSearcher searcher = this.req.getSearcher();
        Query docIdQuery = this.createIdQuery(this.req.getSchema().getUniqueKeyField().getName(), uniqueValue);
        try {
            TopDocs td = searcher.search(docIdQuery, 2);
            if (td.totalHits.value != 1L) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error completing MLT request. Could not fetch document with id [" + uniqueValue + "]");
            }
            ScoreDoc[] scoreDocs = td.scoreDocs;
            return this.parseMLTQuery(this::getFieldsFromSchema, moreLikeThis -> moreLikeThis.like(scoreDocs[0].doc), docIdQuery);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error completing MLT request" + e.getMessage());
        }
    }

    protected Query createIdQuery(String defaultField, String uniqueValue) {
        return new TermQuery(this.req.getSchema().getField(defaultField).getType().getNumberType() != null ? this.createNumericTerm(defaultField, uniqueValue) : new Term(defaultField, uniqueValue));
    }

    private Term createNumericTerm(String field, String uniqueValue) {
        BytesRefBuilder bytesRefBuilder = new BytesRefBuilder();
        bytesRefBuilder.grow(6);
        LegacyNumericUtils.intToPrefixCoded(Integer.parseInt(uniqueValue), 0, bytesRefBuilder);
        return new Term(field, bytesRefBuilder);
    }
}

