/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.neural;

import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.ByteVectorSimilarityQuery;
import org.apache.lucene.search.FloatVectorSimilarityQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.DenseVectorField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.neural.AbstractVectorQParserBase;
import org.apache.solr.util.vector.DenseVectorParser;

public class VectorSimilarityQParser
extends AbstractVectorQParserBase {
    static final String MIN_RETURN = "minReturn";
    static final String MIN_TRAVERSE = "minTraverse";
    static final float DEFAULT_MIN_TRAVERSE = Float.NEGATIVE_INFINITY;

    public VectorSimilarityQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws SyntaxError {
        String fieldName = this.getFieldName();
        SchemaField schemaField = this.req.getCore().getLatestSchema().getField(fieldName);
        DenseVectorField denseVectorType = VectorSimilarityQParser.getCheckedFieldType(schemaField);
        String vectorToSearch = this.getVectorToSearch();
        float minTraverse = this.localParams.getFloat(MIN_TRAVERSE, Float.NEGATIVE_INFINITY);
        Float minReturn = this.localParams.getFloat(MIN_RETURN);
        if (null == minReturn) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "minReturn is required to use Vector Similarity QParser");
        }
        DenseVectorParser vectorBuilder = denseVectorType.getVectorBuilder(vectorToSearch, DenseVectorParser.BuilderPhase.QUERY);
        VectorEncoding vectorEncoding = denseVectorType.getVectorEncoding();
        switch (vectorEncoding) {
            case FLOAT32: {
                return new FloatVectorSimilarityQuery(fieldName, vectorBuilder.getFloatVector(), minTraverse, minReturn.floatValue(), this.getFilterQuery());
            }
            case BYTE: {
                return new ByteVectorSimilarityQuery(fieldName, vectorBuilder.getByteVector(), minTraverse, minReturn.floatValue(), this.getFilterQuery());
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected state. Vector Encoding: " + String.valueOf(vectorEncoding));
    }
}

