/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.circuitbreaker;

import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.Locale;
import org.apache.solr.util.circuitbreaker.CircuitBreaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadAverageCircuitBreaker
extends CircuitBreaker {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private double loadAverageThreshold;
    private static final ThreadLocal<Double> seenLoadAverage = ThreadLocal.withInitial(() -> 0.0);
    private static final ThreadLocal<Double> allowedLoadAverage = ThreadLocal.withInitial(() -> 0.0);

    @Override
    public boolean isTripped() {
        double localAllowedLoadAverage = this.getLoadAverageThreshold();
        double localSeenLoadAverage = this.calculateLiveLoadAverage();
        if (localSeenLoadAverage < 0.0) {
            if (log.isWarnEnabled()) {
                String msg = "Unable to get load average";
                log.warn(msg);
            }
            return false;
        }
        allowedLoadAverage.set(localAllowedLoadAverage);
        seenLoadAverage.set(localSeenLoadAverage);
        return localSeenLoadAverage >= localAllowedLoadAverage;
    }

    @Override
    public String getErrorMessage() {
        return "Load Average Circuit Breaker triggered as seen load average is above allowed threshold.Seen load average " + String.valueOf(seenLoadAverage.get()) + " and allocated threshold " + String.valueOf(allowedLoadAverage.get());
    }

    public LoadAverageCircuitBreaker setThreshold(double thresholdValueUnbounded) {
        if (thresholdValueUnbounded <= 0.0) {
            throw new IllegalStateException("Threshold cannot be less than or equal to zero");
        }
        this.loadAverageThreshold = thresholdValueUnbounded;
        return this;
    }

    public double getLoadAverageThreshold() {
        return this.loadAverageThreshold;
    }

    protected double calculateLiveLoadAverage() {
        return operatingSystemMXBean.getSystemLoadAverage();
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s(threshold=%f, warnOnly=%b)", this.getClass().getSimpleName(), this.loadAverageThreshold, this.isWarnOnly());
    }
}

