/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.incubator.config.ConfigProvider;
import io.opentelemetry.api.incubator.config.DeclarativeConfigException;
import io.opentelemetry.api.incubator.config.GlobalConfigProvider;
import io.opentelemetry.common.ComponentLoader;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.resources.Resource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.logging.Logger;

final class IncubatingUtil {
    private IncubatingUtil() {
    }

    static AutoConfiguredOpenTelemetrySdk configureFromFile(Logger logger, String configurationFile, ComponentLoader componentLoader) {
        AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk;
        logger.fine("Autoconfiguring from configuration file: " + configurationFile);
        FileInputStream fis = new FileInputStream(configurationFile);
        try {
            Class<?> declarativeConfiguration = Class.forName("io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfiguration");
            Method parse = declarativeConfiguration.getMethod("parse", InputStream.class);
            Object model = parse.invoke(null, fis);
            Class<?> openTelemetryConfiguration = Class.forName("io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OpenTelemetryConfigurationModel");
            Method create = declarativeConfiguration.getMethod("create", openTelemetryConfiguration, ComponentLoader.class);
            OpenTelemetrySdk sdk = (OpenTelemetrySdk)create.invoke(null, model, componentLoader);
            Class<?> sdkConfigProvider = Class.forName("io.opentelemetry.sdk.extension.incubator.fileconfig.SdkConfigProvider");
            Method createFileConfigProvider = sdkConfigProvider.getMethod("create", openTelemetryConfiguration, ComponentLoader.class);
            ConfigProvider configProvider = (ConfigProvider)createFileConfigProvider.invoke(null, model, componentLoader);
            autoConfiguredOpenTelemetrySdk = AutoConfiguredOpenTelemetrySdk.create(sdk, Resource.getDefault(), null, configProvider);
        }
        catch (Throwable declarativeConfiguration) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {
                    declarativeConfiguration.addSuppressed(throwable);
                }
                throw declarativeConfiguration;
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException("Configuration file not found", (Throwable)e);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                throw new ConfigurationException("Error configuring from file. Is opentelemetry-sdk-extension-incubator on the classpath?", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof DeclarativeConfigException) {
                    throw IncubatingUtil.toConfigurationException((DeclarativeConfigException)cause);
                }
                throw new ConfigurationException("Unexpected error configuring from file", (Throwable)e);
            }
            catch (IOException e) {
                throw new ConfigurationException("Error closing file", (Throwable)e);
            }
        }
        fis.close();
        return autoConfiguredOpenTelemetrySdk;
    }

    private static ConfigurationException toConfigurationException(DeclarativeConfigException exception) {
        String message = Objects.requireNonNull(exception.getMessage());
        return new ConfigurationException(message, (Throwable)exception);
    }

    static void setGlobalConfigProvider(Object configProvider) {
        GlobalConfigProvider.set((ConfigProvider)((ConfigProvider)configProvider));
    }
}

