/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.projection.VerticalPerspectiveView;

public class VerticalPerspective
extends AbstractCoordTransBuilder {
    @Override
    public String getTransformName() {
        return "vertical_perspective";
    }

    @Override
    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    @Override
    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        this.readStandardParams(ds, ctv);
        double distance = this.readAttributeDouble(ctv, "perspective_point_height", Double.NaN);
        if (Double.isNaN(distance)) {
            distance = this.readAttributeDouble(ctv, "height_above_earth", Double.NaN);
        }
        if (Double.isNaN(this.lon0) || Double.isNaN(this.lat0) || Double.isNaN(distance)) {
            throw new IllegalArgumentException("Vertical Perspective must have: longitude_of_projection_origin, latitude_of_projection_origin, and perspective_point_height(or height_above_earth) attributes");
        }
        VerticalPerspectiveView proj = new VerticalPerspectiveView(this.lat0, this.lon0, this.earth_radius, distance / 1000.0, this.false_easting, this.false_northing);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

