/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.extraction.ExtractionBackend;
import org.apache.solr.handler.extraction.ExtractionMetadata;
import org.apache.solr.handler.extraction.ExtractionRequest;
import org.apache.solr.handler.extraction.SolrContentHandler;
import org.apache.solr.handler.extraction.SolrContentHandlerFactory;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.tika.sax.xpath.Matcher;
import org.apache.tika.sax.xpath.MatchingContentHandler;
import org.apache.tika.sax.xpath.XPathParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class ExtractingDocumentLoader
extends ContentStreamLoader {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String TEXT_FORMAT = "text";
    public static final String XML_FORMAT = "xml";
    final SolrCore core;
    final UpdateRequestProcessor processor;
    final boolean ignoreTikaException;
    private final AddUpdateCommand templateAdd;
    protected SolrContentHandlerFactory factory;
    protected ExtractionBackend backend;

    public ExtractingDocumentLoader(SolrQueryRequest req, UpdateRequestProcessor processor, SolrContentHandlerFactory factory, ExtractionBackend backend) {
        SolrParams params = req.getParams();
        this.core = req.getCore();
        this.processor = processor;
        this.templateAdd = new AddUpdateCommand(req);
        this.templateAdd.overwrite = params.getBool("overwrite", true);
        this.templateAdd.commitWithin = params.getInt("commitWithin", -1);
        this.factory = factory;
        this.backend = backend;
        this.ignoreTikaException = params.getBool("ignoreTikaException", false);
    }

    void doAdd(SolrContentHandler handler, AddUpdateCommand template) throws IOException {
        template.solrDoc = handler.newDocument();
        this.processor.processAdd(template);
    }

    void addDoc(SolrContentHandler handler) throws IOException {
        this.templateAdd.clear();
        this.doAdd(handler, this.templateAdd);
    }

    /*
     * Exception decompiling
     */
    public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream, UpdateRequestProcessor processor) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String extractWithHandler(InputStream inputStream, String xpathExpr, ExtractionRequest extractionRequest, ExtractionMetadata md, DefaultHandler ch) throws Exception {
        if (xpathExpr != null) {
            XPathParser xparser = new XPathParser("xhtml", "http://www.w3.org/1999/xhtml");
            Matcher matcher = xparser.parse(xpathExpr);
            ch = new MatchingContentHandler((ContentHandler)ch, matcher);
        }
        this.backend.extractWithSaxHandler(inputStream, extractionRequest, md, ch);
        return ch.toString();
    }
}

