/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class IfFunction
extends AnalyticsValueStream.AbstractAnalyticsValueStream {
    private final BooleanValue ifExpr;
    private final AnalyticsValueStream thenExpr;
    private final AnalyticsValueStream elseExpr;
    public static final String name = "if";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 3) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The if function requires 3 paramaters, " + params.length + " found.");
        }
        if (!(params[0] instanceof BooleanValue)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The if function requires single-valued numeric parameters. Incorrect parameter: " + params[0].getExpressionStr());
        }
        BooleanValue castedIf = (BooleanValue)params[0];
        AnalyticsValueStream thenExpr = params[1];
        AnalyticsValueStream elseExpr = params[2];
        if (thenExpr instanceof DateValue && elseExpr instanceof DateValue) {
            return new DateIfFunction(castedIf, (DateValue)thenExpr, (DateValue)elseExpr);
        }
        if (thenExpr instanceof DateValueStream && elseExpr instanceof DateValueStream) {
            return new DateStreamIfFunction(castedIf, (DateValueStream)thenExpr, (DateValueStream)elseExpr);
        }
        if (thenExpr instanceof BooleanValue && elseExpr instanceof BooleanValue) {
            return new BooleanIfFunction(castedIf, (BooleanValue)thenExpr, (BooleanValue)elseExpr);
        }
        if (thenExpr instanceof BooleanValueStream && elseExpr instanceof BooleanValueStream) {
            return new BooleanStreamIfFunction(castedIf, (BooleanValueStream)thenExpr, (BooleanValueStream)elseExpr);
        }
        if (thenExpr instanceof IntValue && elseExpr instanceof IntValue) {
            return new IntIfFunction(castedIf, (IntValue)thenExpr, (IntValue)elseExpr);
        }
        if (thenExpr instanceof IntValueStream && elseExpr instanceof IntValueStream) {
            return new IntStreamIfFunction(castedIf, (IntValueStream)thenExpr, (IntValueStream)elseExpr);
        }
        if (thenExpr instanceof LongValue && elseExpr instanceof LongValue) {
            return new LongIfFunction(castedIf, (LongValue)thenExpr, (LongValue)elseExpr);
        }
        if (thenExpr instanceof LongValueStream && elseExpr instanceof LongValueStream) {
            return new LongStreamIfFunction(castedIf, (LongValueStream)thenExpr, (LongValueStream)elseExpr);
        }
        if (thenExpr instanceof FloatValue && elseExpr instanceof FloatValue) {
            return new FloatIfFunction(castedIf, (FloatValue)thenExpr, (FloatValue)elseExpr);
        }
        if (thenExpr instanceof FloatValueStream && elseExpr instanceof FloatValueStream) {
            return new FloatStreamIfFunction(castedIf, (FloatValueStream)thenExpr, (FloatValueStream)elseExpr);
        }
        if (thenExpr instanceof DoubleValue && elseExpr instanceof DoubleValue) {
            return new DoubleIfFunction(castedIf, (DoubleValue)thenExpr, (DoubleValue)elseExpr);
        }
        if (thenExpr instanceof DoubleValueStream && elseExpr instanceof DoubleValueStream) {
            return new DoubleStreamIfFunction(castedIf, (DoubleValueStream)thenExpr, (DoubleValueStream)elseExpr);
        }
        if (thenExpr instanceof StringValue && elseExpr instanceof StringValue) {
            return new StringIfFunction(castedIf, (StringValue)thenExpr, (StringValue)elseExpr);
        }
        if (thenExpr instanceof StringValueStream && elseExpr instanceof StringValueStream) {
            return new StringStreamIfFunction(castedIf, (StringValueStream)thenExpr, (StringValueStream)elseExpr);
        }
        if (thenExpr instanceof AnalyticsValue && elseExpr instanceof AnalyticsValue) {
            return new ValueIfFunction(castedIf, (AnalyticsValue)thenExpr, (AnalyticsValue)elseExpr);
        }
        return new IfFunction(castedIf, thenExpr, elseExpr);
    };

    public IfFunction(BooleanValue ifExpr, AnalyticsValueStream thenExpr, AnalyticsValueStream elseExpr) throws SolrException {
        this.ifExpr = ifExpr;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, ifExpr, thenExpr, elseExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        boolean ifValue = this.ifExpr.getBoolean();
        if (this.ifExpr.exists()) {
            if (ifValue) {
                this.thenExpr.streamObjects(cons);
            } else {
                this.elseExpr.streamObjects(cons);
            }
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }

    static class StringIfFunction
    extends StringValue.AbstractStringValue {
        private final BooleanValue ifExpr;
        private final StringValue thenExpr;
        private final StringValue elseExpr;
        public static final String name = "if";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public StringIfFunction(BooleanValue ifExpr, StringValue thenExpr, StringValue elseExpr) throws SolrException {
            this.ifExpr = ifExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("if", ifExpr, thenExpr, elseExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
        }

        @Override
        public String getString() {
            this.exists = false;
            String value = null;
            boolean ifValue = this.ifExpr.getBoolean();
            if (this.ifExpr.exists()) {
                if (ifValue) {
                    value = this.thenExpr.getString();
                    this.exists = this.thenExpr.exists();
                } else {
                    value = this.elseExpr.getString();
                    this.exists = this.elseExpr.exists();
                }
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class StringStreamIfFunction
    extends StringValueStream.AbstractStringValueStream {
        private final BooleanValue ifExpr;
        private final StringValueStream thenExpr;
        private final StringValueStream elseExpr;
        public static final String name = "if";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public StringStreamIfFunction(BooleanValue ifExpr, StringValueStream thenExpr, StringValueStream elseExpr) throws SolrException {
            this.ifExpr = ifExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("if", ifExpr, thenExpr, elseExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            boolean ifValue = this.ifExpr.getBoolean();
            if (this.ifExpr.exists()) {
                if (ifValue) {
                    this.thenExpr.streamStrings(cons);
                } else {
                    this.elseExpr.streamStrings(cons);
                }
            }
        }

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateIfFunction
    extends DateValue.AbstractDateValue {
        private final BooleanValue ifExpr;
        private final DateValue thenExpr;
        private final DateValue elseExpr;
        public static final String name = "if";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public DateIfFunction(BooleanValue ifExpr, DateValue thenExpr, DateValue elseExpr) throws SolrException {
            this.ifExpr = ifExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("if", ifExpr, thenExpr, elseExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
        }

        @Override
        public long getLong() {
            this.exists = false;
            long value = 0L;
            boolean ifValue = this.ifExpr.getBoolean();
            if (this.ifExpr.exists()) {
                if (ifValue) {
                    value = this.thenExpr.getLong();
                    this.exists = this.thenExpr.exists();
                } else {
                    value = this.elseExpr.getLong();
                    this.exists = this.elseExpr.exists();
                }
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateStreamIfFunction
    extends DateValueStream.AbstractDateValueStream {
        private final BooleanValue ifExpr;
        private final DateValueStream thenExpr;
        private final DateValueStream elseExpr;
        public static final String name = "if";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public DateStreamIfFunction(BooleanValue ifExpr, DateValueStream thenExpr, DateValueStream elseExpr) throws SolrException {
            this.ifExpr = ifExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("if", ifExpr, thenExpr, elseExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            boolean ifValue = this.ifExpr.getBoolean();
            if (this.ifExpr.exists()) {
                if (ifValue) {
                    this.thenExpr.streamLongs(cons);
                } else {
                    this.elseExpr.streamLongs(cons);
                }
            }
        }

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DoubleIfFunction
    extends DoubleValue.AbstractDoubleValue {
        private final BooleanValue ifExpr;
        private final DoubleValue thenExpr;
        private final DoubleValue elseExpr;
        public static final String name = "if";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public DoubleIfFunction(BooleanValue ifExpr, DoubleValue thenExpr, DoubleValue elseExpr) throws SolrException {
            this.ifExpr = ifExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("if", ifExpr, thenExpr, elseExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
        }

        @Override
        public double getDouble() {
            this.exists = false;
            double value = 0.0;
            boolean ifValue = this.ifExpr.getBoolean();
            if (this.ifExpr.exists()) {
                if (ifValue) {
                    value = this.thenExpr.getDouble();
                    this.exists = this.thenExpr.exists();
                } else {
                    value = this.elseExpr.getDouble();
                    this.exists = this.elseExpr.exists();
                }
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DoubleStreamIfFunction
    extends DoubleValueStream.AbstractDoubleValueStream {
        private final BooleanValue ifExpr;
        private final DoubleValueStream thenExpr;
        private final DoubleValueStream elseExpr;
        public static final String name = "if";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public DoubleStreamIfFunction(BooleanValue ifExpr, DoubleValueStream thenExpr, DoubleValueStream elseExpr) throws SolrException {
            this.ifExpr = ifExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("if", ifExpr, thenExpr, elseExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
        }

        @Override
        public void streamDoubles(DoubleConsumer cons) {
            boolean ifValue = this.ifExpr.getBoolean();
            if (this.ifExpr.exists()) {
                if (ifValue) {
                    this.thenExpr.streamDoubles(cons);
                } else {
                    this.elseExpr.streamDoubles(cons);
                }
            }
        }

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class FloatIfFunction
    extends FloatValue.AbstractFloatValue {
        private final BooleanValue ifExpr;
        private final FloatValue thenExpr;
        private final FloatValue elseExpr;
        public static final String name = "if";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public FloatIfFunction(BooleanValue ifExpr, FloatValue thenExpr, FloatValue elseExpr) throws SolrException {
            this.ifExpr = ifExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("if", ifExpr, thenExpr, elseExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
        }

        @Override
        public float getFloat() {
            this.exists = false;
            float value = 0.0f;
            boolean ifValue = this.ifExpr.getBoolean();
            if (this.ifExpr.exists()) {
                if (ifValue) {
                    value = this.thenExpr.getFloat();
                    this.exists = this.thenExpr.exists();
                } else {
                    value = this.elseExpr.getFloat();
                    this.exists = this.elseExpr.exists();
                }
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class FloatStreamIfFunction
    extends FloatValueStream.AbstractFloatValueStream {
        private final BooleanValue ifExpr;
        private final FloatValueStream thenExpr;
        private final FloatValueStream elseExpr;
        public static final String name = "if";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public FloatStreamIfFunction(BooleanValue ifExpr, FloatValueStream thenExpr, FloatValueStream elseExpr) throws SolrException {
            this.ifExpr = ifExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("if", ifExpr, thenExpr, elseExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
        }

        @Override
        public void streamFloats(FloatConsumer cons) {
            boolean ifValue = this.ifExpr.getBoolean();
            if (this.ifExpr.exists()) {
                if (ifValue) {
                    this.thenExpr.streamFloats(cons);
                } else {
                    this.elseExpr.streamFloats(cons);
                }
            }
        }

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongIfFunction
    extends LongValue.AbstractLongValue {
        private final BooleanValue ifExpr;
        private final LongValue thenExpr;
        private final LongValue elseExpr;
        public static final String name = "if";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public LongIfFunction(BooleanValue ifExpr, LongValue thenExpr, LongValue elseExpr) throws SolrException {
            this.ifExpr = ifExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("if", ifExpr, thenExpr, elseExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
        }

        @Override
        public long getLong() {
            this.exists = false;
            long value = 0L;
            boolean ifValue = this.ifExpr.getBoolean();
            if (this.ifExpr.exists()) {
                if (ifValue) {
                    value = this.thenExpr.getLong();
                    this.exists = this.thenExpr.exists();
                } else {
                    value = this.elseExpr.getLong();
                    this.exists = this.elseExpr.exists();
                }
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongStreamIfFunction
    extends LongValueStream.AbstractLongValueStream {
        private final BooleanValue ifExpr;
        private final LongValueStream thenExpr;
        private final LongValueStream elseExpr;
        public static final String name = "if";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public LongStreamIfFunction(BooleanValue ifExpr, LongValueStream thenExpr, LongValueStream elseExpr) throws SolrException {
            this.ifExpr = ifExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("if", ifExpr, thenExpr, elseExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            boolean ifValue = this.ifExpr.getBoolean();
            if (this.ifExpr.exists()) {
                if (ifValue) {
                    this.thenExpr.streamLongs(cons);
                } else {
                    this.elseExpr.streamLongs(cons);
                }
            }
        }

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class IntIfFunction
    extends IntValue.AbstractIntValue {
        private final BooleanValue ifExpr;
        private final IntValue thenExpr;
        private final IntValue elseExpr;
        public static final String name = "if";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public IntIfFunction(BooleanValue ifExpr, IntValue thenExpr, IntValue elseExpr) throws SolrException {
            this.ifExpr = ifExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("if", ifExpr, thenExpr, elseExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
        }

        @Override
        public int getInt() {
            this.exists = false;
            int value = 0;
            boolean ifValue = this.ifExpr.getBoolean();
            if (this.ifExpr.exists()) {
                if (ifValue) {
                    value = this.thenExpr.getInt();
                    this.exists = this.thenExpr.exists();
                } else {
                    value = this.elseExpr.getInt();
                    this.exists = this.elseExpr.exists();
                }
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class IntStreamIfFunction
    extends IntValueStream.AbstractIntValueStream {
        private final BooleanValue ifExpr;
        private final IntValueStream thenExpr;
        private final IntValueStream elseExpr;
        public static final String name = "if";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public IntStreamIfFunction(BooleanValue ifExpr, IntValueStream thenExpr, IntValueStream elseExpr) throws SolrException {
            this.ifExpr = ifExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("if", ifExpr, thenExpr, elseExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
        }

        @Override
        public void streamInts(IntConsumer cons) {
            boolean ifValue = this.ifExpr.getBoolean();
            if (this.ifExpr.exists()) {
                if (ifValue) {
                    this.thenExpr.streamInts(cons);
                } else {
                    this.elseExpr.streamInts(cons);
                }
            }
        }

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanIfFunction
    extends BooleanValue.AbstractBooleanValue {
        private final BooleanValue ifExpr;
        private final BooleanValue thenExpr;
        private final BooleanValue elseExpr;
        public static final String name = "if";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public BooleanIfFunction(BooleanValue ifExpr, BooleanValue thenExpr, BooleanValue elseExpr) throws SolrException {
            this.ifExpr = ifExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("if", ifExpr, thenExpr, elseExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
        }

        @Override
        public boolean getBoolean() {
            this.exists = false;
            boolean value = false;
            boolean ifValue = this.ifExpr.getBoolean();
            if (this.ifExpr.exists()) {
                if (ifValue) {
                    value = this.thenExpr.getBoolean();
                    this.exists = this.thenExpr.exists();
                } else {
                    value = this.elseExpr.getBoolean();
                    this.exists = this.elseExpr.exists();
                }
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanStreamIfFunction
    extends BooleanValueStream.AbstractBooleanValueStream {
        private final BooleanValue ifExpr;
        private final BooleanValueStream thenExpr;
        private final BooleanValueStream elseExpr;
        public static final String name = "if";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public BooleanStreamIfFunction(BooleanValue ifExpr, BooleanValueStream thenExpr, BooleanValueStream elseExpr) throws SolrException {
            this.ifExpr = ifExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("if", ifExpr, thenExpr, elseExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
        }

        @Override
        public void streamBooleans(BooleanConsumer cons) {
            boolean ifValue = this.ifExpr.getBoolean();
            if (this.ifExpr.exists()) {
                if (ifValue) {
                    this.thenExpr.streamBooleans(cons);
                } else {
                    this.elseExpr.streamBooleans(cons);
                }
            }
        }

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class ValueIfFunction
    extends AnalyticsValue.AbstractAnalyticsValue {
        private final BooleanValue ifExpr;
        private final AnalyticsValue thenExpr;
        private final AnalyticsValue elseExpr;
        public static final String name = "if";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public ValueIfFunction(BooleanValue ifExpr, AnalyticsValue thenExpr, AnalyticsValue elseExpr) throws SolrException {
            this.ifExpr = ifExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("if", ifExpr, thenExpr, elseExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
        }

        @Override
        public Object getObject() {
            this.exists = false;
            Object value = null;
            boolean ifValue = this.ifExpr.getBoolean();
            if (this.ifExpr.exists()) {
                if (ifValue) {
                    value = this.thenExpr.getObject();
                    this.exists = this.thenExpr.exists();
                } else {
                    value = this.elseExpr.getObject();
                    this.exists = this.elseExpr.exists();
                }
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }
}

