/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.api.model.DeleteNodeRequestBody;
import org.apache.solr.client.api.model.GetNodeCommandStatusResponse;
import org.apache.solr.client.api.model.PublicKeyResponse;
import org.apache.solr.client.api.model.ReplaceNodeRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class NodeApi {

    public static class ReplaceNode
    extends SolrRequest<ReplaceNodeResponse> {
        private final ReplaceNodeRequestBody requestBody;
        private final String sourceNodeName;

        public ReplaceNode(String sourceNodeName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/cluster/nodes/{sourceNodeName}/replace".replace("{sourceNodeName}", sourceNodeName));
            this.sourceNodeName = sourceNodeName;
            this.requestBody = new ReplaceNodeRequestBody();
        }

        public void setTargetNodeName(String targetNodeName) {
            this.requestBody.targetNodeName = targetNodeName;
        }

        public void setWaitForFinalState(Boolean waitForFinalState) {
            this.requestBody.waitForFinalState = waitForFinalState;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new JacksonContentWriter(this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected ReplaceNodeResponse createResponse(SolrClient client) {
            return new ReplaceNodeResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ReplaceNodeResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public ReplaceNodeResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class GetPublicKey
    extends SolrRequest<GetPublicKeyResponse> {
        public GetPublicKey() {
            super(SolrRequest.METHOD.valueOf("GET"), "/node/key");
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected GetPublicKeyResponse createResponse(SolrClient client) {
            return new GetPublicKeyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetPublicKeyResponse
    extends JacksonParsingResponse<PublicKeyResponse> {
        public GetPublicKeyResponse() {
            super(PublicKeyResponse.class);
        }
    }

    public static class GetCommandStatus
    extends SolrRequest<GetCommandStatusResponse> {
        private final String requestId;

        public GetCommandStatus(String requestId) {
            super(SolrRequest.METHOD.valueOf("GET"), "/node/commands/{requestId}".replace("{requestId}", requestId));
            this.requestId = requestId;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected GetCommandStatusResponse createResponse(SolrClient client) {
            return new GetCommandStatusResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetCommandStatusResponse
    extends JacksonParsingResponse<GetNodeCommandStatusResponse> {
        public GetCommandStatusResponse() {
            super(GetNodeCommandStatusResponse.class);
        }
    }

    public static class DeleteNode
    extends SolrRequest<DeleteNodeResponse> {
        private final DeleteNodeRequestBody requestBody;
        private final String nodeName;

        public DeleteNode(String nodeName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/cluster/nodes/{nodeName}/clear".replace("{nodeName}", nodeName));
            this.nodeName = nodeName;
            this.requestBody = new DeleteNodeRequestBody();
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new JacksonContentWriter(this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected DeleteNodeResponse createResponse(SolrClient client) {
            return new DeleteNodeResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteNodeResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public DeleteNodeResponse() {
            super(SolrJerseyResponse.class);
        }
    }
}

