/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.routing;

import java.lang.invoke.MethodHandles;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.routing.AffinityReplicaListTransformerFactory;
import org.apache.solr.client.solrj.routing.NodePreferenceRulesComparator;
import org.apache.solr.client.solrj.routing.PreferenceRule;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.client.solrj.routing.ReplicaListTransformerFactory;
import org.apache.solr.client.solrj.routing.ShufflingReplicaListTransformer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.NodesSysProps;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestReplicaListTransformerGenerator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Random r = new Random();
    private static final ReplicaListTransformer shufflingReplicaListTransformer = new ShufflingReplicaListTransformer(r);
    public static final ReplicaListTransformerFactory RANDOM_RLTF = (configSpec, requestParams, fallback) -> shufflingReplicaListTransformer;
    private final ReplicaListTransformerFactory stableRltFactory;
    private final ReplicaListTransformerFactory defaultRltFactory;
    private final String defaultShardPreferences;
    private final String nodeName;
    private final String baseUrl;
    private final String hostName;
    private final NodesSysProps sysProps;

    public RequestReplicaListTransformerGenerator() {
        this(null);
    }

    public RequestReplicaListTransformerGenerator(ReplicaListTransformerFactory defaultRltFactory) {
        this(defaultRltFactory, null);
    }

    public RequestReplicaListTransformerGenerator(ReplicaListTransformerFactory defaultRltFactory, ReplicaListTransformerFactory stableRltFactory) {
        this(defaultRltFactory, stableRltFactory, null, null, null, null, null);
    }

    public RequestReplicaListTransformerGenerator(String defaultShardPreferences, String nodeName, String baseUrl, String hostName, NodesSysProps sysProps) {
        this(null, null, defaultShardPreferences, nodeName, baseUrl, hostName, sysProps);
    }

    public RequestReplicaListTransformerGenerator(ReplicaListTransformerFactory defaultRltFactory, ReplicaListTransformerFactory stableRltFactory, String defaultShardPreferences, String nodeName, String baseUrl, String hostName, NodesSysProps sysProps) {
        this.defaultRltFactory = Objects.requireNonNullElse(defaultRltFactory, RANDOM_RLTF);
        this.stableRltFactory = Objects.requireNonNullElseGet(stableRltFactory, AffinityReplicaListTransformerFactory::new);
        this.defaultShardPreferences = Objects.requireNonNullElse(defaultShardPreferences, "");
        this.nodeName = nodeName;
        this.baseUrl = baseUrl;
        this.hostName = hostName;
        this.sysProps = sysProps;
    }

    public ReplicaListTransformer getReplicaListTransformer(SolrParams requestParams) {
        return this.getReplicaListTransformer(requestParams, null);
    }

    public ReplicaListTransformer getReplicaListTransformer(SolrParams requestParams, String defaultShardPreferences) {
        return this.getReplicaListTransformer(requestParams, defaultShardPreferences, null, null, null, null);
    }

    public ReplicaListTransformer getReplicaListTransformer(SolrParams requestParams, String defaultShardPreferences, String nodeName, String baseUrl, String hostName, NodesSysProps sysProps) {
        String shardsPreferenceSpec = requestParams.get("shards.preference", defaultShardPreferences = Objects.requireNonNullElse(defaultShardPreferences, this.defaultShardPreferences));
        if (!shardsPreferenceSpec.isEmpty()) {
            List<PreferenceRule> preferenceRules = PreferenceRule.from(shardsPreferenceSpec);
            NodePreferenceRulesComparator replicaComp = new NodePreferenceRulesComparator(preferenceRules, requestParams, nodeName != null ? nodeName : this.nodeName, baseUrl != null ? baseUrl : this.baseUrl, hostName != null ? hostName : this.hostName, sysProps != null ? sysProps : this.sysProps, this.defaultRltFactory, this.stableRltFactory);
            ReplicaListTransformer baseReplicaListTransformer = replicaComp.getBaseReplicaListTransformer();
            if (replicaComp.getPreferenceRules() == null || replicaComp.getPreferenceRules().isEmpty()) {
                return baseReplicaListTransformer;
            }
            return new TopLevelReplicaListTransformer(replicaComp, baseReplicaListTransformer);
        }
        return this.defaultRltFactory.getInstance(null, requestParams, RANDOM_RLTF);
    }

    private static final class TopLevelReplicaListTransformer
    implements ReplicaListTransformer {
        private final NodePreferenceRulesComparator replicaComp;
        private final ReplicaListTransformer baseReplicaListTransformer;

        public TopLevelReplicaListTransformer(NodePreferenceRulesComparator replicaComp, ReplicaListTransformer baseReplicaListTransformer) {
            this.replicaComp = replicaComp;
            this.baseReplicaListTransformer = baseReplicaListTransformer;
        }

        @Override
        public <T> void transform(List<T> choices) {
            if (choices.size() > 1) {
                Comparator<T> comparator;
                if (log.isDebugEnabled()) {
                    log.debug("Applying the following sorting preferences to replicas: {}", (Object)this.replicaComp.getPreferenceRules().stream().map(PreferenceRule::toString).collect(Collectors.joining(",", "[", "]")));
                }
                try {
                    comparator = this.replicaComp.getComparator(choices.get(0));
                }
                catch (IllegalArgumentException iae) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, iae.getMessage());
                }
                if (comparator == null) {
                    this.baseReplicaListTransformer.transform(choices);
                    return;
                }
                try {
                    choices.sort(comparator);
                }
                catch (IllegalArgumentException iae) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, iae.getMessage());
                }
                Iterator<T> iter = choices.iterator();
                T prev = iter.next();
                int idx = 1;
                int boundaryCount = 0;
                int[] boundaries = new int[choices.size()];
                do {
                    T current;
                    if (comparator.compare(prev, current = iter.next()) != 0) {
                        boundaries[boundaryCount++] = idx;
                    }
                    prev = current;
                    ++idx;
                } while (iter.hasNext());
                boundaries[boundaryCount++] = idx;
                int startIdx = 0;
                for (int i = 0; i < boundaryCount; ++i) {
                    int endIdx = boundaries[i];
                    if (endIdx - startIdx > 1) {
                        this.baseReplicaListTransformer.transform(choices.subList(startIdx, endIdx));
                    }
                    startIdx = endIdx;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Applied sorting preferences to replica list: {}", (Object)choices.stream().map(Object::toString).collect(Collectors.joining(",", "[", "]")));
                }
            }
        }
    }
}

