/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrDocumentBase;
import org.apache.solr.common.SolrInputField;

public class SolrInputDocument
extends SolrDocumentBase<SolrInputField, SolrInputDocument>
implements Iterable<SolrInputField> {
    private final Map<String, SolrInputField> _fields;
    private List<SolrInputDocument> _childDocuments;

    public SolrInputDocument() {
        this._fields = new LinkedHashMap<String, SolrInputField>();
    }

    public SolrInputDocument(String ... fields) {
        this._fields = new LinkedHashMap<String, SolrInputField>();
        assert (fields.length % 2 == 0);
        for (int i = 0; i < fields.length; i += 2) {
            this.addField(fields[i], fields[i + 1]);
        }
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        BiConsumer<CharSequence, Object> bc = ew.getBiConsumer();
        BiConsumer<CharSequence, Object> wrapper = (k, o) -> {
            if (o instanceof SolrInputField) {
                o = ((SolrInputField)o).getValue();
            }
            bc.accept((CharSequence)k, o);
        };
        this._fields.forEach(wrapper);
        if (this._childDocuments != null) {
            ew.put((CharSequence)"_childDocuments_", this._childDocuments);
        }
    }

    public SolrInputDocument(Map<String, SolrInputField> fields) {
        this._fields = fields;
    }

    @Override
    public void clear() {
        if (this._fields != null) {
            this._fields.clear();
        }
        this._childDocuments = null;
    }

    @Override
    public void addField(String name, Object value) {
        SolrInputField field = this._fields.get(name);
        if (field == null || field.value == null) {
            this.setField(name, value);
        } else {
            field.addValue(value);
        }
    }

    @Override
    public Object getFieldValue(String name) {
        SolrInputField field = this.getField(name);
        Object o = null;
        if (field != null) {
            o = field.getFirstValue();
        }
        return o;
    }

    @Override
    public Collection<Object> getFieldValues(String name) {
        SolrInputField field = this.getField(name);
        if (field != null) {
            return field.getValues();
        }
        return null;
    }

    @Override
    public Collection<String> getFieldNames() {
        return this._fields.keySet();
    }

    @Override
    public void setField(String name, Object value) {
        SolrInputField field = new SolrInputField(name);
        this._fields.put(name, field);
        field.setValue(value);
    }

    public SolrInputField removeField(String name) {
        return this._fields.remove(name);
    }

    public SolrInputField getField(String field) {
        return this._fields.get(field);
    }

    @Override
    public Iterator<SolrInputField> iterator() {
        return this._fields.values().iterator();
    }

    public String toString() {
        return "SolrInputDocument(fields: " + String.valueOf(this._fields.values()) + (String)(this._childDocuments == null ? "" : ", children: " + String.valueOf(this._childDocuments)) + ")";
    }

    public SolrInputDocument deepCopy() {
        SolrInputDocument clone = new SolrInputDocument();
        Set<Map.Entry<String, SolrInputField>> entries = this._fields.entrySet();
        for (Map.Entry<String, SolrInputField> fieldEntry : entries) {
            clone._fields.put(fieldEntry.getKey(), fieldEntry.getValue().deepCopy());
        }
        if (this._childDocuments != null) {
            clone._childDocuments = new ArrayList<SolrInputDocument>(this._childDocuments.size());
            for (SolrInputDocument child : this._childDocuments) {
                clone._childDocuments.add(child.deepCopy());
            }
        }
        return clone;
    }

    @Override
    public boolean containsKey(Object key) {
        return this._fields.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._fields.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, SolrInputField>> entrySet() {
        return this._fields.entrySet();
    }

    @Override
    public SolrInputField get(Object key) {
        return this._fields.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this._fields.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this._fields.keySet();
    }

    @Override
    public SolrInputField put(String key, SolrInputField value) {
        return this._fields.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends SolrInputField> t) {
        this._fields.putAll(t);
    }

    @Override
    public SolrInputField remove(Object key) {
        return this._fields.remove(key);
    }

    @Override
    public int size() {
        return this._fields.size();
    }

    @Override
    public Collection<SolrInputField> values() {
        return this._fields.values();
    }

    @Override
    public void addChildDocument(SolrInputDocument child) {
        if (this._childDocuments == null) {
            this._childDocuments = new ArrayList<SolrInputDocument>();
        }
        this._childDocuments.add(child);
    }

    @Override
    public void addChildDocuments(Collection<SolrInputDocument> children) {
        for (SolrInputDocument child : children) {
            this.addChildDocument(child);
        }
    }

    public void visitSelfAndNestedDocs(BiConsumer<String, SolrInputDocument> consumer) {
        consumer.accept(null, this);
        for (SolrInputField field : this.values()) {
            Object value = field.getValue();
            if (value instanceof SolrInputDocument) {
                consumer.accept(field.name, (SolrInputDocument)value);
                continue;
            }
            if (!(value instanceof Collection)) continue;
            Collection cVal = (Collection)value;
            for (Object v : cVal) {
                if (!(v instanceof SolrInputDocument)) break;
                consumer.accept(field.name, (SolrInputDocument)v);
            }
        }
        if (this._childDocuments != null) {
            for (SolrInputDocument childDocument : this._childDocuments) {
                consumer.accept(null, childDocument);
            }
        }
    }

    @Override
    public List<SolrInputDocument> getChildDocuments() {
        return this._childDocuments;
    }

    @Override
    public boolean hasChildDocuments() {
        boolean isEmpty = this._childDocuments == null || this._childDocuments.isEmpty();
        return !isEmpty;
    }

    @Override
    @Deprecated
    public int getChildDocumentCount() {
        return this.hasChildDocuments() ? this._childDocuments.size() : 0;
    }
}

