/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

import com.tdunning.math.stats.AVLGroupTree;
import com.tdunning.math.stats.AbstractTDigest;
import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.TDigest;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class AVLTreeDigest
extends AbstractTDigest {
    final Random gen = new Random();
    private final double compression;
    private AVLGroupTree summary;
    private long count = 0L;
    private static final int VERBOSE_ENCODING = 1;
    private static final int SMALL_ENCODING = 2;

    public AVLTreeDigest(double compression) {
        this.compression = compression;
        this.summary = new AVLGroupTree(false);
    }

    @Override
    public TDigest recordAllData() {
        if (this.summary.size() != 0) {
            throw new IllegalStateException("Can only ask to record added data on an empty summary");
        }
        this.summary = new AVLGroupTree(true);
        return super.recordAllData();
    }

    @Override
    public int centroidCount() {
        return this.summary.size();
    }

    @Override
    void add(double x, int w, Centroid base) {
        if (x != base.mean() || w != base.count()) {
            throw new IllegalArgumentException();
        }
        this.add(x, w, base.data());
    }

    @Override
    public void add(double x, int w) {
        this.add(x, w, (List<Double>)null);
    }

    @Override
    public void add(List<? extends TDigest> others) {
        for (TDigest tDigest : others) {
            this.setMinMax(Math.min(this.min, tDigest.getMin()), Math.max(this.max, tDigest.getMax()));
            for (Centroid centroid : tDigest.centroids()) {
                this.add(centroid.mean(), centroid.count(), this.recordAllData ? centroid.data() : null);
            }
        }
    }

    public void add(double x, int w, List<Double> data) {
        int start;
        this.checkValue(x);
        if (x < this.min) {
            this.min = x;
        }
        if (x > this.max) {
            this.max = x;
        }
        if ((start = this.summary.floor(x)) == 0) {
            start = this.summary.first();
        }
        if (start == 0) {
            assert (this.summary.size() == 0);
            this.summary.add(x, w, data);
            this.count = w;
        } else {
            double minDistance = Double.MAX_VALUE;
            int lastNeighbor = 0;
            int neighbor = start;
            while (neighbor != 0) {
                double z = Math.abs(this.summary.mean(neighbor) - x);
                if (z < minDistance) {
                    start = neighbor;
                    minDistance = z;
                } else if (z > minDistance) {
                    lastNeighbor = neighbor;
                    break;
                }
                neighbor = this.summary.next(neighbor);
            }
            int closest = 0;
            double n = 0.0;
            int neighbor2 = start;
            while (neighbor2 != lastNeighbor) {
                assert (minDistance == Math.abs(this.summary.mean(neighbor2) - x));
                double q0 = (double)this.summary.headSum(neighbor2) / (double)this.count;
                double q1 = q0 + (double)this.summary.count(neighbor2) / (double)this.count;
                double k = (double)this.count * Math.min(this.scale.max(q0, this.compression, this.count), this.scale.max(q1, this.compression, this.count));
                if ((double)(this.summary.count(neighbor2) + w) <= k) {
                    n += 1.0;
                    if (this.gen.nextDouble() < 1.0 / n) {
                        closest = neighbor2;
                    }
                }
                neighbor2 = this.summary.next(neighbor2);
            }
            if (closest == 0) {
                this.summary.add(x, w, data);
            } else {
                double centroid = this.summary.mean(closest);
                int count = this.summary.count(closest);
                List<Double> d = this.summary.data(closest);
                if (d != null) {
                    if (w == 1) {
                        d.add(x);
                    } else {
                        d.addAll(data);
                    }
                }
                centroid = AVLTreeDigest.weightedAverage(centroid, count, x, w);
                this.summary.update(closest, centroid, count += w, d, false);
            }
            this.count += (long)w;
            if ((double)this.summary.size() > 20.0 * this.compression) {
                this.compress();
            }
        }
    }

    @Override
    public void compress() {
        if (this.summary.size() <= 1) {
            return;
        }
        double n0 = 0.0;
        double k0 = (double)this.count * this.scale.max(n0 / (double)this.count, this.compression, this.count);
        int node = this.summary.first();
        int w0 = this.summary.count(node);
        double n1 = n0 + (double)this.summary.count(node);
        int w1 = 0;
        while (node != 0) {
            double k1;
            int after = this.summary.next(node);
            while (after != 0 && !((double)(w0 + (w1 = this.summary.count(after))) > Math.min(k0, k1 = (double)this.count * this.scale.max((n1 + (double)w1) / (double)this.count, this.compression, this.count)))) {
                double mean = AVLTreeDigest.weightedAverage(this.summary.mean(node), w0, this.summary.mean(after), w1);
                List<Double> d1 = this.summary.data(node);
                List<Double> d2 = this.summary.data(after);
                if (d1 != null && d2 != null) {
                    d1.addAll(d2);
                }
                this.summary.update(node, mean, w0 + w1, d1, true);
                int tmp = this.summary.next(after);
                this.summary.remove(after);
                after = tmp;
                n1 += (double)w1;
                w0 += w1;
            }
            node = after;
            if (node == 0) continue;
            n0 = n1;
            k0 = (double)this.count * this.scale.max(n0 / (double)this.count, this.compression, this.count);
            w0 = w1;
            n1 = n0 + (double)w0;
        }
    }

    @Override
    public long size() {
        return this.count;
    }

    @Override
    public double cdf(double x) {
        AVLGroupTree values = this.summary;
        if (values.size() == 0) {
            return Double.NaN;
        }
        if (values.size() == 1) {
            if (x < values.mean(values.first())) {
                return 0.0;
            }
            if (x > values.mean(values.first())) {
                return 1.0;
            }
            return 0.5;
        }
        if (x < this.min) {
            return 0.0;
        }
        if (x == this.min) {
            double dw = 0.0;
            for (Centroid value : values) {
                if (value.mean() != x) break;
                dw += (double)value.count();
            }
            return dw / 2.0 / (double)this.size();
        }
        assert (x > this.min);
        if (x > this.max) {
            return 1.0;
        }
        if (x == this.max) {
            int ix = values.last();
            double dw = 0.0;
            while (ix != 0 && values.mean(ix) == x) {
                dw += (double)values.count(ix);
                ix = values.prev(ix);
            }
            long n = this.size();
            return ((double)n - dw / 2.0) / (double)n;
        }
        assert (x < this.max);
        int first = values.first();
        double firstMean = values.mean(first);
        if (x > this.min && x < firstMean) {
            return this.interpolateTail(values, x, first, firstMean, this.min);
        }
        int last = values.last();
        double lastMean = values.mean(last);
        if (x < this.max && x > lastMean) {
            return 1.0 - this.interpolateTail(values, x, last, lastMean, this.max);
        }
        assert (values.size() >= 2);
        assert (x >= firstMean);
        assert (x <= lastMean);
        Iterator<Centroid> it = values.iterator();
        Centroid a = it.next();
        double aMean = a.mean();
        double aWeight = a.count();
        if (x == aMean) {
            return aWeight / 2.0 / (double)this.size();
        }
        assert (x > aMean);
        Centroid b = it.next();
        double bMean = b.mean();
        double bWeight = b.count();
        assert (bMean >= aMean);
        double weightSoFar = 0.0;
        while (bWeight > 0.0) {
            assert (x > aMean);
            if (x == bMean) {
                assert (bMean > aMean);
                weightSoFar += aWeight;
                while (it.hasNext() && x == (b = it.next()).mean()) {
                    bWeight += (double)b.count();
                }
                return (weightSoFar + bWeight / 2.0) / (double)this.size();
            }
            assert (x < bMean || x > bMean);
            if (x < bMean) {
                assert (aMean < bMean);
                if (aWeight == 1.0) {
                    if (bWeight == 1.0) {
                        return (weightSoFar + 1.0) / (double)this.size();
                    }
                    double partialWeight = (x - aMean) / (bMean - aMean) * bWeight / 2.0;
                    return (weightSoFar + 1.0 + partialWeight) / (double)this.size();
                }
                if (bWeight == 1.0) {
                    double partialWeight = (x - aMean) / (bMean - aMean) * aWeight / 2.0;
                    return (weightSoFar + aWeight / 2.0 + partialWeight) / (double)this.size();
                }
                double partialWeight = (x - aMean) / (bMean - aMean) * (aWeight + bWeight) / 2.0;
                return (weightSoFar + aWeight / 2.0 + partialWeight) / (double)this.size();
            }
            weightSoFar += aWeight;
            assert (x > bMean);
            if (it.hasNext()) {
                aMean = bMean;
                aWeight = bWeight;
                b = it.next();
                bMean = b.mean();
                bWeight = b.count();
                assert (bMean >= aMean);
                continue;
            }
            bWeight = 0.0;
        }
        throw new IllegalStateException("Ran out of centroids");
    }

    private double interpolateTail(AVLGroupTree values, double x, int node, double mean, double extremeValue) {
        int count = values.count(node);
        assert (count > 1);
        if (count == 2) {
            return 1.0 / (double)this.size();
        }
        double weight = (double)count / 2.0 - 1.0;
        double partialWeight = (extremeValue - x) / (extremeValue - mean) * weight;
        return (partialWeight + 1.0) / (double)this.size();
    }

    @Override
    public double quantile(double q) {
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException("q should be in [0,1], got " + q);
        }
        AVLGroupTree values = this.summary;
        if (values.size() == 0) {
            return Double.NaN;
        }
        if (values.size() == 1) {
            return values.iterator().next().mean();
        }
        double index = q * (double)this.count;
        if (index < 1.0) {
            return this.min;
        }
        if (index >= (double)(this.count - 1L)) {
            return this.max;
        }
        int currentNode = values.first();
        int currentWeight = values.count(currentNode);
        if (currentWeight == 2 && index <= 2.0) {
            return 2.0 * values.mean(currentNode) - this.min;
        }
        if (values.count(values.last()) == 2 && index > (double)(this.count - 2L)) {
            return 2.0 * values.mean(values.last()) - this.max;
        }
        double weightSoFar = (double)currentWeight / 2.0;
        if (index < weightSoFar) {
            return AVLTreeDigest.weightedAverage(this.min, weightSoFar - index, values.mean(currentNode), index - 1.0);
        }
        for (int i = 0; i < values.size() - 1; ++i) {
            int nextNode = values.next(currentNode);
            int nextWeight = values.count(nextNode);
            double dw = (double)(currentWeight + nextWeight) / 2.0;
            if (index < weightSoFar + dw) {
                double leftExclusion = 0.0;
                double rightExclusion = 0.0;
                if (currentWeight == 1) {
                    if (index < weightSoFar + 0.5) {
                        return values.mean(currentNode);
                    }
                    leftExclusion = 0.5;
                }
                if (nextWeight == 1) {
                    if (index >= weightSoFar + dw - 0.5) {
                        return values.mean(nextNode);
                    }
                    rightExclusion = 0.5;
                }
                assert (leftExclusion + rightExclusion < 1.0);
                assert (dw > 1.0);
                double w1 = index - weightSoFar - leftExclusion;
                double w2 = weightSoFar + dw - index - rightExclusion;
                return AVLTreeDigest.weightedAverage(values.mean(currentNode), w2, values.mean(nextNode), w1);
            }
            weightSoFar += dw;
            currentNode = nextNode;
            currentWeight = nextWeight;
        }
        assert (currentWeight > 1);
        assert (index - weightSoFar < (double)currentWeight / 2.0 - 1.0);
        assert ((double)this.count - weightSoFar > 0.5);
        double w1 = index - weightSoFar;
        double w2 = (double)(this.count - 1L) - index;
        return AVLTreeDigest.weightedAverage(values.mean(currentNode), w2, this.max, w1);
    }

    @Override
    public Collection<Centroid> centroids() {
        return Collections.unmodifiableCollection(this.summary);
    }

    @Override
    public double compression() {
        return this.compression;
    }

    @Override
    public int byteSize() {
        this.compress();
        return 32 + this.summary.size() * 12;
    }

    @Override
    public int smallByteSize() {
        int bound = this.byteSize();
        ByteBuffer buf = ByteBuffer.allocate(bound);
        this.asSmallBytes(buf);
        return buf.position();
    }

    @Override
    public void asBytes(ByteBuffer buf) {
        buf.putInt(1);
        buf.putDouble(this.min);
        buf.putDouble(this.max);
        buf.putDouble((float)this.compression());
        buf.putInt(this.summary.size());
        for (Centroid centroid : this.summary) {
            buf.putDouble(centroid.mean());
        }
        for (Centroid centroid : this.summary) {
            buf.putInt(centroid.count());
        }
    }

    @Override
    public void asSmallBytes(ByteBuffer buf) {
        buf.putInt(2);
        buf.putDouble(this.min);
        buf.putDouble(this.max);
        buf.putDouble(this.compression());
        buf.putInt(this.summary.size());
        double x = 0.0;
        for (Centroid centroid : this.summary) {
            double delta = centroid.mean() - x;
            x = centroid.mean();
            buf.putFloat((float)delta);
        }
        for (Centroid centroid : this.summary) {
            int n = centroid.count();
            AVLTreeDigest.encode(buf, n);
        }
    }

    public static AVLTreeDigest fromBytes(ByteBuffer buf) {
        int encoding = buf.getInt();
        if (encoding == 1) {
            int i;
            double min = buf.getDouble();
            double max = buf.getDouble();
            double compression = buf.getDouble();
            AVLTreeDigest r = new AVLTreeDigest(compression);
            r.setMinMax(min, max);
            int n = buf.getInt();
            double[] means = new double[n];
            for (i = 0; i < n; ++i) {
                means[i] = buf.getDouble();
            }
            for (i = 0; i < n; ++i) {
                r.add(means[i], buf.getInt());
            }
            return r;
        }
        if (encoding == 2) {
            int i;
            double min = buf.getDouble();
            double max = buf.getDouble();
            double compression = buf.getDouble();
            AVLTreeDigest r = new AVLTreeDigest(compression);
            r.setMinMax(min, max);
            int n = buf.getInt();
            double[] means = new double[n];
            double x = 0.0;
            for (i = 0; i < n; ++i) {
                double delta = buf.getFloat();
                means[i] = x += delta;
            }
            for (i = 0; i < n; ++i) {
                int z = AVLTreeDigest.decode(buf);
                r.add(means[i], z);
            }
            return r;
        }
        throw new IllegalStateException("Invalid format for serialized histogram");
    }
}

