/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.queries.intervals.ConjunctionIntervalsSource;
import org.apache.lucene.queries.intervals.ConjunctionMatchesIterator;
import org.apache.lucene.queries.intervals.Disjunctions;
import org.apache.lucene.queries.intervals.FilteringIntervalIterator;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.queries.intervals.IntervalsSource;

class OverlappingIntervalsSource
extends ConjunctionIntervalsSource {
    private final IntervalsSource source;
    private final IntervalsSource reference;

    OverlappingIntervalsSource(IntervalsSource source, IntervalsSource reference) {
        super(Arrays.asList(source, reference));
        this.source = source;
        this.reference = reference;
    }

    @Override
    protected IntervalIterator combine(List<IntervalIterator> iterators) {
        assert (iterators.size() == 2);
        IntervalIterator a = iterators.get(0);
        IntervalIterator b = iterators.get(1);
        return new FilteringIntervalIterator(a, b){

            @Override
            public int nextInterval() throws IOException {
                if (!this.bpos) {
                    return Integer.MAX_VALUE;
                }
                while (this.a.nextInterval() != Integer.MAX_VALUE) {
                    while (this.b.end() < this.a.start()) {
                        if (this.b.nextInterval() != Integer.MAX_VALUE) continue;
                        this.bpos = false;
                        return Integer.MAX_VALUE;
                    }
                    if (this.b.start() > this.a.end()) continue;
                    return this.a.start();
                }
                this.bpos = false;
                return Integer.MAX_VALUE;
            }
        };
    }

    @Override
    protected IntervalMatchesIterator createMatchesIterator(IntervalIterator it, List<IntervalMatchesIterator> subs) {
        assert (subs.size() == 2);
        return new ConjunctionMatchesIterator(it, List.of(subs.get(0)));
    }

    @Override
    public int minExtent() {
        return this.source.minExtent();
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Disjunctions.pullUp(Arrays.asList(this.source, this.reference), ss -> new OverlappingIntervalsSource((IntervalsSource)ss.get(0), (IntervalsSource)ss.get(1)));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subSources);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof OverlappingIntervalsSource)) {
            return false;
        }
        OverlappingIntervalsSource o = (OverlappingIntervalsSource)other;
        return Objects.equals(this.subSources, o.subSources);
    }

    @Override
    public String toString() {
        return "OVERLAPPING(" + String.valueOf(this.source) + "," + String.valueOf(this.reference) + ")";
    }
}

