/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.modifiers;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Modifier;
import org.sunflow.core.ParameterList;
import org.sunflow.core.ShadingState;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.PerlinScalar;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;

public class PerlinModifier
implements Modifier {
    private int function = 0;
    private float scale = 50.0f;
    private float size = 1.0f;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.function = parameterList.getInt("function", this.function);
        this.size = parameterList.getFloat("size", this.size);
        this.scale = parameterList.getFloat("scale", this.scale);
        return true;
    }

    public void modify(ShadingState shadingState) {
        Point3 point3 = shadingState.transformWorldToObject(shadingState.getPoint());
        point3.x *= this.size;
        point3.y *= this.size;
        point3.z *= this.size;
        Vector3 vector3 = shadingState.transformNormalWorldToObject(shadingState.getNormal());
        double d = this.f(point3.x, point3.y, point3.z);
        double d2 = this.f((double)point3.x + 1.0E-4, point3.y, point3.z);
        double d3 = this.f(point3.x, (double)point3.y + 1.0E-4, point3.z);
        double d4 = this.f(point3.x, point3.y, (double)point3.z + 1.0E-4);
        vector3.x = (float)((double)vector3.x - (double)this.scale * (d2 - d) / 1.0E-4);
        vector3.y = (float)((double)vector3.y - (double)this.scale * (d3 - d) / 1.0E-4);
        vector3.z = (float)((double)vector3.z - (double)this.scale * (d4 - d) / 1.0E-4);
        vector3.normalize();
        shadingState.getNormal().set(shadingState.transformNormalObjectToWorld(vector3));
        shadingState.getNormal().normalize();
        shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
    }

    double f(double d, double d2, double d3) {
        switch (this.function) {
            case 0: {
                return 0.03 * PerlinModifier.noise(d, d2, d3, 8.0);
            }
            case 1: {
                return 0.01 * PerlinModifier.stripes(d + 2.0 * PerlinModifier.turbulence(d, d2, d3, 1.0), 1.6);
            }
        }
        return -0.1 * PerlinModifier.turbulence(d, d2, d3, 1.0);
    }

    private static final double stripes(double d, double d2) {
        double d3 = 0.5 + 0.5 * Math.sin(d2 * 2.0 * Math.PI * d);
        return d3 * d3 - 0.5;
    }

    private static final double turbulence(double d, double d2, double d3, double d4) {
        double d5 = -0.5;
        while (d4 <= 25.0) {
            d5 += Math.abs(PerlinModifier.noise(d, d2, d3, d4) / d4);
            d4 *= 2.0;
        }
        return d5;
    }

    private static final double noise(double d, double d2, double d3, double d4) {
        double d5 = 0.707 * d - 0.707 * d3;
        double d6 = 0.707 * d + 0.707 * d3;
        double d7 = 0.707 * d5 + 0.707 * d2;
        d5 = 0.707 * d5 - 0.707 * d2;
        return PerlinScalar.snoise((float)(d4 * d5 + 100.0), (float)(d4 * d7), (float)(d4 * d6));
    }
}

