/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2DRetained;
import javax.vecmath.Point2f;

public class Texture2D
extends Texture {
    public static final int ALLOW_DETAIL_TEXTURE_READ = 15;
    public static final int LINEAR_DETAIL = 6;
    public static final int LINEAR_DETAIL_RGB = 7;
    public static final int LINEAR_DETAIL_ALPHA = 8;
    public static final int DETAIL_ADD = 0;
    public static final int DETAIL_MODULATE = 1;
    private static final int[] readCapabilities = new int[]{15};

    public Texture2D() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Texture2D(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Texture2D(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, n5);
        this.setDefaultReadCapabilities(readCapabilities);
    }

    @Override
    public void setMagFilter(int n) {
        this.checkForLiveOrCompiled();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("Texture29"));
            }
        }
        ((Texture2DRetained)this.retained).initMagFilter(n);
    }

    public void setDetailImage(ImageComponent2D imageComponent2D) {
        this.checkForLiveOrCompiled();
        ((Texture2DRetained)this.retained).initDetailImage(imageComponent2D);
    }

    public ImageComponent2D getDetailImage() {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture2D0"));
        }
        return ((Texture2DRetained)this.retained).getDetailImage();
    }

    public void setDetailTextureMode(int n) {
        this.checkForLiveOrCompiled();
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture2D1"));
        }
        ((Texture2DRetained)this.retained).initDetailTextureMode(n);
    }

    public int getDetailTextureMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture2D0"));
        }
        return ((Texture2DRetained)this.retained).getDetailTextureMode();
    }

    public void setDetailTextureLevel(int n) {
        this.checkForLiveOrCompiled();
        if (n < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture2D2"));
        }
        ((Texture2DRetained)this.retained).initDetailTextureLevel(n);
    }

    public int getDetailTextureLevel() {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture2D0"));
        }
        return ((Texture2DRetained)this.retained).getDetailTextureLevel();
    }

    public void setDetailTextureFunc(float[] fArray, float[] fArray2) {
        this.checkForLiveOrCompiled();
        if (!(fArray != null && fArray2 != null && fArray.length == fArray2.length || fArray == null && fArray2 == null)) {
            throw new IllegalStateException(J3dI18N.getString("Texture2D3"));
        }
        ((Texture2DRetained)this.retained).initDetailTextureFunc(fArray, fArray2);
    }

    public void setDetailTextureFunc(Point2f[] point2fArray) {
        this.checkForLiveOrCompiled();
        ((Texture2DRetained)this.retained).initDetailTextureFunc(point2fArray);
    }

    public int getDetailTextureFuncPointsCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture2D0"));
        }
        return ((Texture2DRetained)this.retained).getDetailTextureFuncPointsCount();
    }

    public void getDetailTextureFunc(float[] fArray, float[] fArray2) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture2D0"));
        }
        ((Texture2DRetained)this.retained).getDetailTextureFunc(fArray, fArray2);
    }

    public void getDetailTextureFunc(Point2f[] point2fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture2D0"));
        }
        ((Texture2DRetained)this.retained).getDetailTextureFunc(point2fArray);
    }

    @Override
    void createRetained() {
        this.retained = new Texture2DRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        Texture2DRetained texture2DRetained = (Texture2DRetained)this.retained;
        Texture2D texture2D = new Texture2D(texture2DRetained.getMipMapMode(), texture2DRetained.format, texture2DRetained.width, texture2DRetained.height);
        texture2D.duplicateNodeComponent(this);
        return texture2D;
    }

    @Override
    public void duplicateNodeComponent(NodeComponent nodeComponent) {
        this.checkDuplicateNodeComponent(nodeComponent);
    }

    @Override
    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        Texture2DRetained texture2DRetained = (Texture2DRetained)nodeComponent.retained;
        Texture2DRetained texture2DRetained2 = (Texture2DRetained)this.retained;
        texture2DRetained2.initDetailImage(texture2DRetained.getDetailImage());
        texture2DRetained2.initDetailTextureMode(texture2DRetained.getDetailTextureMode());
        texture2DRetained2.initDetailTextureLevel(texture2DRetained.getDetailTextureLevel());
        texture2DRetained2.initDetailTextureFunc(texture2DRetained.getDetailTextureFunc());
    }
}

