/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import org.parosproxy.paros.core.scanner.Alert;
import org.zaproxy.zap.extension.alert.AlertNode;
import org.zaproxy.zap.extension.alert.AlertTreeModel;

public class TextAlertTree {
    private TextAlertTree() {
    }

    public static String toString(AlertTreeModel model) {
        StringBuilder sb = new StringBuilder();
        TextAlertTree.dumpRoot(model.getRoot(), sb);
        return sb.toString();
    }

    private static void dumpRoot(AlertNode root, StringBuilder sb) {
        sb.append("- Alerts\n");
        root.children().asIterator().forEachRemaining(child -> TextAlertTree.dumpAlert((AlertNode)child, sb));
    }

    private static void dumpAlert(AlertNode node, StringBuilder sb) {
        sb.append("  - ");
        sb.append(Alert.MSG_RISK[node.getRisk()]);
        sb.append(": ");
        sb.append(node.getNodeName());
        sb.append("\n");
        node.children().asIterator().forEachRemaining(child -> TextAlertTree.dumpAlertInstance((AlertNode)child, sb));
    }

    private static void dumpAlertInstance(AlertNode node, StringBuilder sb) {
        sb.append("    - ");
        sb.append(node.getNodeName());
        sb.append("\n");
    }
}

