FastJet
=======

The FastJet package, written by Matteo Cacciari and Gavin Salam and
Gregory Soyez, provides a fast implementation of several
longitudinally invariant sequential recombination jet algorithms, in
particular the longitudinally invariant $k_t$ jet algorithm, the
inclusive longitudinally invariant version of the Cambridge/Aachen
jet-algorithm, and the inclusive anti-$k_t$ algorithm.

The implementation is based on the geometrical methods described in M.
Cacciari and G.P. Salam, Phys. Lett. B 641 (2006) 57
[[hep-ph/0512210](https://arxiv.org/abs/hep-ph/0512210)]. The full
FastJet manual is available at https://fastjet.fr and is included with this
distribution as doc/fastjet-doc.tex. Users of FastJet should cite the
arXiv version of the manual,
[arXiv:1111.6097](https://arxiv.org/abs/hep-ph/1111.6097).

Means are also provided for accessing 3rd party jet-algorithm software
via a common (plugin) interface and FastJet notably comes with numerous
current and legacy jet algorithms, including SISCone, an infrared-safe
seedless stable-cone type algorithm introduced in G.P. Salam and G.
Soyez, JHEP 0705 (2007) 086
[[arXiv:0704.0292](https://arxiv.org/abs/0704.0292)].

Various tools are also provided related to jet areas and
subtraction. They can be used with any infrared safe jet algorithm,
both native and plugin. The ideas behind them are described in
M. Cacciari, G.P. Salam, Phys.Lett.B 659 (2008) 119 [[arXiv:0707.1378](https://arxiv.org/abs/0707.1378)], and
M. Cacciari, G.P. Salam and G. Soyez, JHEP 0804 (2008) 005 [[arXiv:0802.1188](https://arxiv.org/abs/0802.1188)]

Tools are also provided to facilitate jet substructure analyses.

Installation
------------
Installation instructions are provided in
[INSTALL-CMake.md](INSTALL-CMake.md) for the CMake build system and
[INSTALL](INSTALL) for the autotools build system.

Note that to benefit from NlnN implementation (relevant for a number
of particles N greater than 15000 roughly) of the kt (and anti-kt) jet
algorithm , you will need to download CGAL from https://www.cgal.org/
and compile it before compiling the FastJet library. The NlnN
implementation of the Cambridge/Aachen jet-algorithm is independent of
CGAL.

Automatic documentation can be generated by running the doxygen command 
(if not installed on your system see www.doxygen.org) in the main 
directory. It will create the html/ and latex/ directories containing 
detailed documentation of all classes etc.. More standard
documentation is to be found in the doc/ directory. 

Directory structure
-------------------

|                  |                                                              |
|------------------|--------------------------------------------------------------|
| doc/      	   |  Documentation                                               |
| src/		       |  the .cc files for the FastJet library                       |
| include/	       |  the include (.hh) files for the FastJet library             |
| example/         |  contains example programs (list them with "ls -1 [0-9]*.cc")|
| example/data/    |  contains files with data for example events                 |
| example/root/    |  an example root script to show jets as calorimeter towers   |
| plugins/         |  the various plugin jet algorithms                           |
| tools/           |  location for a number of the tools (substructure, etc.)     |
| fortran_wrapper/ |  an illustration of how to use fastjet from fortran          |
