/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.DoubleRange;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.Track;
import tim.prune.data.UnitSetLibrary;

public class TrackExtents {
    private final Track _track;
    private final DoubleRange _xRange;
    private final DoubleRange _yRange;
    private static final double BORDER_MULTIPLIER = 1.1;

    public TrackExtents(Track track) {
        this._track = track;
        this._xRange = track.getXRange().copy();
        this._yRange = track.getYRange().copy();
    }

    public void applySquareBorder() {
        double d = this._xRange.getMidValue();
        double d2 = this._yRange.getMidValue();
        double d3 = Math.max(this._xRange.getRange(), this._yRange.getRange()) * 1.1;
        if (this.getHorizontalDistanceMetres() < 10.0) {
            d3 = 0.1;
        }
        this._xRange.addValue(d - d3 / 2.0);
        this._xRange.addValue(d + d3 / 2.0);
        this._yRange.addValue(d2 - d3 / 2.0);
        this._yRange.addValue(d2 + d3 / 2.0);
    }

    public DoubleRange getXRange() {
        return this._xRange;
    }

    public DoubleRange getYRange() {
        return this._yRange;
    }

    public DoubleRange getAltitudeRange() {
        int n = this._track.getNumPoints();
        DoubleRange doubleRange = new DoubleRange();
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = this._track.getPoint(n2);
            if (dataPoint != null && dataPoint.hasAltitude()) {
                doubleRange.addValue(dataPoint.getAltitude().getMetricValue());
            }
            ++n2;
        }
        return doubleRange;
    }

    public double getHorizontalDistanceMetres() {
        DoubleRange doubleRange = this._track.getLonRange();
        DoubleRange doubleRange2 = this._track.getLatRange();
        DataPoint dataPoint = new DataPoint(Latitude.make(doubleRange2.getMinimum()), Longitude.make(doubleRange.getMidValue()));
        DataPoint dataPoint2 = new DataPoint(Latitude.make(doubleRange2.getMaximum()), Longitude.make(doubleRange.getMidValue()));
        double d = Distance.convertRadiansToDistance(DataPoint.calculateRadiansBetween(dataPoint2, dataPoint), UnitSetLibrary.UNITS_METRES);
        DataPoint dataPoint3 = new DataPoint(Latitude.make(doubleRange2.getMidValue()), Longitude.make(doubleRange.getMinimum()));
        DataPoint dataPoint4 = new DataPoint(Latitude.make(doubleRange2.getMidValue()), Longitude.make(doubleRange.getMaximum()));
        double d2 = Distance.convertRadiansToDistance(DataPoint.calculateRadiansBetween(dataPoint3, dataPoint4), UnitSetLibrary.UNITS_METRES);
        double d3 = Math.max(d, d2) * 1.1;
        return d3;
    }
}

