/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.browser;

import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.TrackInfo;
import tim.prune.function.browser.MapCoords;

public abstract class UrlGenerator {
    public static String generateUrl(WebService webService, TrackInfo trackInfo) {
        switch (webService) {
            case MAP_SOURCE_GOOGLE: {
                return UrlGenerator.generateGoogleUrl(trackInfo);
            }
            case MAP_SOURCE_MAPQUEST: {
                return UrlGenerator.generateMapquestUrl(trackInfo);
            }
            case MAP_SOURCE_BING: {
                return UrlGenerator.generateBingUrl(trackInfo);
            }
            case MAP_SOURCE_MAPILLARY: {
                return UrlGenerator.generateMapillaryUrl(trackInfo);
            }
            case MAP_SOURCE_PEAKFINDER: {
                return UrlGenerator.generatePeakfinderUrl(trackInfo);
            }
            case MAP_SOURCE_GEOHACK: {
                return UrlGenerator.generateGeohackUrl(trackInfo);
            }
            case MAP_SOURCE_GRAPHHOPPER: {
                return UrlGenerator.generateGraphHopperUrl(trackInfo);
            }
        }
        return UrlGenerator.generateOpenStreetMapUrl(trackInfo);
    }

    private static String generateGoogleUrl(TrackInfo trackInfo) {
        MapCoords mapCoords = MapCoords.from(trackInfo);
        if (mapCoords == null) {
            return null;
        }
        String string = "https://" + I18nManager.getText("url.googlemaps") + "/?ll=" + mapCoords.getLatitude() + "," + mapCoords.getLongitude() + "&spn=" + mapCoords.getLatSpan() + "," + mapCoords.getLonSpan();
        DataPoint dataPoint = trackInfo.getCurrentPoint();
        if (dataPoint != null) {
            string = String.valueOf(string) + "&q=" + mapCoords.getLatitude() + "," + mapCoords.getLongitude();
            if (dataPoint.getWaypointName() != null) {
                string = String.valueOf(string) + "(" + dataPoint.getWaypointName() + ")";
            }
        }
        return string;
    }

    private static String generateMapquestUrl(TrackInfo trackInfo) {
        MapCoords mapCoords = MapCoords.from(trackInfo);
        if (mapCoords == null) {
            return null;
        }
        return "https://www.mapquest.com/latlng/" + mapCoords.getLatitude() + "," + mapCoords.getLongitude();
    }

    private static String generateBingUrl(TrackInfo trackInfo) {
        MapCoords mapCoords = MapCoords.from(trackInfo);
        if (mapCoords == null) {
            return null;
        }
        return "https://www.bing.com/maps?cp=" + mapCoords.getLatitude() + "~" + mapCoords.getLongitude() + "&where1=" + mapCoords.getLatitude() + "%2C%20" + mapCoords.getLongitude();
    }

    private static String generateGraphHopperUrl(TrackInfo trackInfo) {
        if (trackInfo != null && trackInfo.getTrack() != null && trackInfo.getTrack().getNumPoints() >= 2) {
            if (trackInfo.getTrack().getNumPoints() == 2) {
                return UrlGenerator.generateGraphHopperUrl(trackInfo.getTrack().getPoint(0), trackInfo.getTrack().getPoint(1));
            }
            if (trackInfo.getSelection().hasRangeSelected()) {
                int n = trackInfo.getSelection().getStart();
                int n2 = trackInfo.getSelection().getEnd();
                return UrlGenerator.generateGraphHopperUrl(trackInfo.getTrack().getPoint(n), trackInfo.getTrack().getPoint(n2));
            }
        }
        return null;
    }

    private static String generateGraphHopperUrl(DataPoint dataPoint, DataPoint dataPoint2) {
        MapCoords mapCoords = MapCoords.from(dataPoint);
        MapCoords mapCoords2 = MapCoords.from(dataPoint2);
        if (mapCoords == null || mapCoords2 == null) {
            return null;
        }
        return "https://graphhopper.com/maps/?point=" + mapCoords.getLatitude() + "%2C" + mapCoords.getLongitude() + "&point=" + mapCoords2.getLatitude() + "%2C" + mapCoords2.getLongitude() + "&locale=" + I18nManager.getText("wikipedia.lang") + "&elevation=true&weighting=fastest";
    }

    private static String generateOpenStreetMapUrl(TrackInfo trackInfo) {
        MapCoords mapCoords = MapCoords.minValues(trackInfo);
        MapCoords mapCoords2 = MapCoords.maxValues(trackInfo);
        if (mapCoords == null || mapCoords2 == null) {
            return null;
        }
        String string = "https://www.openstreetmap.org/?minlat=" + mapCoords.getLatitude() + "&maxlat=" + mapCoords2.getLatitude() + "&minlon=" + mapCoords.getLongitude() + "&maxlon=" + mapCoords2.getLongitude();
        MapCoords mapCoords3 = MapCoords.from(trackInfo.getCurrentPoint());
        if (mapCoords3 != null) {
            string = String.valueOf(string) + "&mlat=" + mapCoords3.getLatitude() + "&mlon=" + mapCoords3.getLongitude();
        }
        return string;
    }

    private static String generatePeakfinderUrl(TrackInfo trackInfo) {
        MapCoords mapCoords = MapCoords.from(trackInfo.getCurrentPoint());
        if (mapCoords == null) {
            return null;
        }
        return "https://www.peakfinder.org/?lat=" + mapCoords.getLatitude() + "&lng=" + mapCoords.getLongitude();
    }

    private static String generateGeohackUrl(TrackInfo trackInfo) {
        MapCoords mapCoords = MapCoords.from(trackInfo.getCurrentPoint());
        if (mapCoords == null) {
            return null;
        }
        return "https://tools.wmflabs.org/geohack/geohack.php?params=" + mapCoords.getLatitude() + "_N_" + mapCoords.getLongitude() + "_E";
    }

    private static String generateMapillaryUrl(TrackInfo trackInfo) {
        MapCoords mapCoords = MapCoords.from(trackInfo);
        if (mapCoords == null) {
            return null;
        }
        return "https://www.mapillary.com/app/?lat=" + mapCoords.getLatitude() + "&lng=" + mapCoords.getLongitude() + "&z=16";
    }

    public static enum WebService {
        MAP_SOURCE_GOOGLE,
        MAP_SOURCE_OSM,
        MAP_SOURCE_MAPQUEST,
        MAP_SOURCE_BING,
        MAP_SOURCE_PEAKFINDER,
        MAP_SOURCE_GEOHACK,
        MAP_SOURCE_MAPILLARY,
        MAP_SOURCE_GRAPHHOPPER;

    }
}

