/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import tim.prune.function.filesleuth.SearchResult;
import tim.prune.function.filesleuth.TrackListListener;
import tim.prune.function.filesleuth.data.Filter;
import tim.prune.function.filesleuth.data.TrackFile;
import tim.prune.function.filesleuth.data.TrackFileList;
import tim.prune.function.filesleuth.data.TrackFileStatus;
import tim.prune.function.filesleuth.extract.ContentExtractor;
import tim.prune.function.filesleuth.extract.ExtractorFactory;
import tim.prune.function.filesleuth.gui.ResultsTableModel;

public class TrackMatcher
implements TrackListListener {
    private final TrackFileList _tracks;
    private final ResultsTableModel _tableModel;
    private boolean _searching = false;
    private int _searchFromIndex = -1;
    private Filter _filter = Filter.EMPTY_FILTER;
    private final ArrayList<SearchResult> _results = new ArrayList();

    public TrackMatcher(TrackFileList trackFileList, ResultsTableModel resultsTableModel) {
        this._tracks = trackFileList;
        this._tableModel = resultsTableModel;
        this._tracks.addListener(this);
    }

    public void setFilter(Filter filter) {
        Filter.Comparison comparison;
        if (filter == null) {
            filter = Filter.EMPTY_FILTER;
        }
        if ((comparison = Filter.compare(this._filter, filter)) == Filter.Comparison.SAME) {
            return;
        }
        this._filter = filter;
        this.resetCheckFlags(comparison);
        this.setIndexOrStart(0);
    }

    @Override
    public void reactToTrackListChange(int n) {
        this.setIndexOrStart(n);
    }

    private synchronized void setIndexOrStart(int n) {
        if (this._searching) {
            this._searchFromIndex = this._searchFromIndex < 0 ? n : Math.min(this._searchFromIndex, n);
        } else {
            this._searchFromIndex = n;
            this._searching = true;
            new Thread(this::run).start();
        }
    }

    private synchronized int checkContinue() {
        this._searching = this._searchFromIndex >= 0;
        return this._searchFromIndex;
    }

    private synchronized int getSearchFromIndex() {
        return this._searchFromIndex;
    }

    private synchronized void clearSearchFromIndex() {
        this._searchFromIndex = -1;
    }

    public void run() {
        int n = Math.min(this._results.size(), this.getSearchFromIndex());
        n = Math.max(n, 0);
        do {
            this.clearSearchFromIndex();
            List<TrackFile> list = this._tracks.getCurrentContents();
            int n2 = n;
            while (n2 < list.size()) {
                SearchResult searchResult;
                TrackFile trackFile = list.get(n2);
                TrackFileStatus trackFileStatus = trackFile.getStatus();
                if (n2 >= this._results.size()) {
                    searchResult = new SearchResult(trackFile);
                    this._results.add(searchResult);
                } else {
                    searchResult = this._results.get(n2);
                }
                if (trackFileStatus != searchResult.getFileStatusWhenChecked() || searchResult.needsRecheck()) {
                    ContentExtractor contentExtractor;
                    this._filter.apply(searchResult);
                    if (searchResult.isMatch() && this._filter.hasLocationFilter() && ((contentExtractor = ExtractorFactory.createExtractor(trackFile.getFile())) == null || !contentExtractor.matchesFilter(this._filter.getLocationFilter()))) {
                        searchResult.setIsMatch(false);
                    }
                }
                ++n2;
            }
            ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
            for (SearchResult searchResult : this._results) {
                if (searchResult.isMatch()) {
                    arrayList.add(searchResult);
                }
                SwingUtilities.invokeLater(() -> this._tableModel.setResults(arrayList));
            }
        } while ((n = this.checkContinue()) >= 0);
    }

    private void resetCheckFlags(Filter.Comparison comparison) {
        boolean bl = comparison == Filter.Comparison.NARROWER;
        for (SearchResult searchResult : this._results) {
            if (searchResult.isMatch() != bl) continue;
            searchResult.setNeedsRecheck();
        }
    }
}

