/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import tim.prune.config.Config;
import tim.prune.data.DoubleRange;
import tim.prune.data.Track;
import tim.prune.data.TrackExtents;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.MapTileManager;
import tim.prune.gui.map.TileConsumer;
import tim.prune.save.GroutedImage;
import tim.prune.save.Grouter;
import tim.prune.save.TileFetcher;

public class MapGrouter
implements TileConsumer,
Grouter {
    private GroutedImage _lastGroutedImage = null;
    private int _currentZoom = -1;
    private BufferedImage _tempImage = null;
    private Object _imageLock = new Object();

    public synchronized void clearMapImage() {
        if (this._lastGroutedImage != null) {
            this._lastGroutedImage.flush();
        }
        this._lastGroutedImage = null;
    }

    private synchronized void setCurrentZoom(int n) {
        this._currentZoom = n;
    }

    public GroutedImage createMapImage(Track track, MapSource mapSource, int n, Config config) {
        return this.createMapImage(track, mapSource, n, false, config);
    }

    public GroutedImage createMapImage(Track track, MapSource mapSource, int n, boolean bl, Config config) {
        this.setCurrentZoom(n);
        TrackExtents trackExtents = new TrackExtents(track);
        trackExtents.applySquareBorder();
        DoubleRange doubleRange = trackExtents.getXRange();
        DoubleRange doubleRange2 = trackExtents.getYRange();
        int n2 = 1 << n;
        int n3 = (int)(doubleRange.getMinimum() * (double)n2);
        int n4 = (int)(doubleRange.getMaximum() * (double)n2);
        int n5 = (int)(doubleRange2.getMinimum() * (double)n2);
        int n6 = (int)(doubleRange2.getMaximum() * (double)n2);
        int n7 = (int)(trackExtents.getXRange().getRange() * (double)n2 * 256.0);
        if (n7 < 2 || n == 0) {
            return null;
        }
        this.createImage(n7);
        MapTileManager mapTileManager = new MapTileManager(this);
        mapTileManager.setMapSource(mapSource);
        mapTileManager.enableTileDownloading(bl);
        mapTileManager.setZoom(n);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n10 < mapSource.getNumLayers()) {
            int n11;
            int n12 = (int)(((double)n3 - doubleRange.getMinimum() * (double)n2) * 256.0);
            ArrayList<TileFetcher> arrayList = new ArrayList<TileFetcher>();
            int n13 = n3;
            while (n13 <= n4) {
                n11 = (int)(((double)n5 - doubleRange2.getMinimum() * (double)n2) * 256.0);
                int n14 = n5;
                while (n14 <= n6) {
                    if (n != this._currentZoom) break;
                    Image image = mapTileManager.getTile(n10, n13, n14, true, config);
                    int n15 = 0;
                    while (image == null && bl && n15 < 3) {
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException interruptedException) {}
                        image = mapTileManager.getTile(n10, n13, n14, false, config);
                        ++n15;
                    }
                    if (image != null) {
                        TileFetcher tileFetcher = new TileFetcher(this, image, n12, n11);
                        arrayList.add(tileFetcher);
                        tileFetcher.go();
                        ++n8;
                    } else {
                        ++n9;
                    }
                    n11 += 256;
                    ++n14;
                }
                n12 += 256;
                ++n13;
            }
            n13 = this.areAllFetchersDone(arrayList) ? 1 : 0;
            n11 = 0;
            while (n11 < 10 && n13 == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                n13 = this.areAllFetchersDone(arrayList) ? 1 : 0;
                ++n11;
            }
            ++n10;
        }
        if (n8 == 0) {
            this._tempImage = null;
        }
        GroutedImage groutedImage = new GroutedImage(this._tempImage, n8, n9);
        groutedImage.setXRange(doubleRange);
        groutedImage.setYRange(doubleRange2);
        this._lastGroutedImage = groutedImage;
        return groutedImage;
    }

    private boolean areAllFetchersDone(ArrayList<TileFetcher> arrayList) {
        for (TileFetcher tileFetcher : arrayList) {
            if (tileFetcher.isDone()) continue;
            return false;
        }
        return true;
    }

    public synchronized GroutedImage getMapImage(Track track, MapSource mapSource, int n, Config config) {
        if (this._lastGroutedImage == null) {
            this._lastGroutedImage = this.createMapImage(track, mapSource, n, config);
        }
        return this._lastGroutedImage;
    }

    @Override
    public void tilesUpdated(boolean bl) {
    }

    @Override
    public void reportCacheFailure() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createImage(int n) {
        Object object = this._imageLock;
        synchronized (object) {
            this._tempImage = new BufferedImage(n, n, 1);
            Graphics graphics = this._tempImage.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, n, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tileReady(Image image, int n, int n2) {
        Object object = this._imageLock;
        synchronized (object) {
            if (this._tempImage != null) {
                this._tempImage.getGraphics().drawImage(image, n, n2, null);
            }
        }
    }
}

