# How to setup HedgeDoc SAML with Keycloak
## Configuring Keycloak
### Get the public certificate
1. Select the Realm you want to use for your HedgeDoc SAML
2. Select "Realm Settings" in left sidebar
3. Select the "Keys" tab
4. Click the button "Certificate" at `RS256` algorithm
![keycloak_idp_cert](../../images/auth/keycloak_idp_cert.png)
5. Copy this key and save it to the file specified in `saml.idpCert` property of the HedgeDoc configuration or `CMD_SAML_IDPCERT` environment variable

### Create a new client
1. Select "Client" in left sidebar
![keycloak_clients_overview](../../images/auth/keycloak_clients_overview.png)
2. Click on the "Create" button
3. Set a Client ID and specify this in `saml.issuer` property of the HedgeDoc configuration or `CMD_SAML_ISSUER` environment variable
4. Select `SAML` as Client Protocol
5. Set Client SAML Endpoint to `https://hedgedoc.example.com/auth/saml` (replace `https://hedgedoc.example.com` with the base URL of your HedgeDoc installation)
![keycloak_add_client](../../images/auth/keycloak_add_client.png)
6. Leave "Client Signature Required" enabled
7. Set Root URL to `https://hedgedoc.example.com` (replace it here also with the base URL of your HedgeDoc installation)
8. Set Valid Redirect URIs to `https://hedgedoc.example.com/auth/saml/callback` (you should also define all other domains of your HedgeDoc installtion with the suffix `/auth/saml/callback`)
9. Set Base URL to `/`
![keycloak_client_overview](../../images/auth/keycloak_client_overview.png)
10. _(optional)_ You can set which Name ID Format should be used

## Configure HedgeDoc
### Config file
You have to put the following block inside your `config.json`:
```json
"saml": {
  "issuer": "hedgedoc", // Change to the "Client ID" specified in the Keycloak Client
  "identifierFormat": "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified",
  "idpSsoUrl": "https://keycloak.example.org/auth/realms/test/protocol/saml", // replace keycloak.example.org with the url of your keycloak server
  "idpCert": "/path/to/the/cert.pem",
  "clientCert": "/path/to/the/key.pem" // this one is optional, see below
}
```

### Environment Variables
- `CMD_SAML_IDPSSOURL`: `https://keycloak.example.org/auth/realms/test/protocol/saml` (replace keycloak.example.org with the url of your keycloak server)
- `CMD_SAML_IDPCERT`: `/path/to/the/cert.pem`
- *(optional, see below)* `CMD_SAML_CLIENTCERT`: `/path/to/the/key.pem`
- `CMD_SAML_ISSUER`: `hedgedoc` (Change to the "Client ID" specified in the Keycloak Client)
- `CMD_SAML_IDENTIFIERFORMAT`: `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified`


## Client certificate *(optional)*
If you want keycloak to be able to verify HedgeDoc, you hava to create a client certificate. There are two options for this:

### Create Private Keys for Signing
1. Generate the private key and certificate with the following commands:
```shell
openssl genrsa -out priv.pem 2048
openssl req -new -x509 -key priv.pem -out cert.pem
```
*execute the following steps in keycloak*

2. Select "Client" in left sidebar
3. Go to your HedgeDoc-Client
4. Select the "SAML Keys" tab
![keycloak_saml_import_cert](../../images/auth/keycloak_saml_import_cert.png)
5. Click on "Import"
6. Select `Certificate PEM` as "Archive Format"
7. Now upload the generated cert.pem (in this case named `cert.pem`)
![keycloak_saml_import_cert_details](../../images/auth/keycloak_saml_import_cert_details.png)
8. Click on "Import"
9. Move or copy this key (in this case named `key.pem`) and save it to the file specified in `saml.clientCert` property of the HedgeDoc configuration or in the enviroment-variable `CMD_SAML_CLIENTCERT`


### Convert Private Certificate generated by KeyCloak
Instead if generating you own certificate, you can also use the one generated by keycloak.

1. Select "Client" in left sidebar
2. Go to your HedgeDoc-Client
3. Select the "SAML Keys" tab
![keycloak_saml_export_cert](../../images/auth/keycloak_saml_export_cert.png)

5. Now click on "Export"
6. Here you can select the output format, choose `PKCS12`. You also have to set a password. Choose your own.
![keycloak_saml_export_cert_details](../../images/auth/keycloak_saml_export_cert_details.png)
6. Click on "Download" and save the file somewhere on you computer
7. You now have to extract the private Key. You can do this with the following command. WHen asked, enter your password.
```shell
openssl pkcs12 -in keystore.p12 -out key.pem -nocerts -nodes
```
8. Move or copy this key (in this case named `key.pem`) and save it to the file specified in `saml.idpCert` property of the HedgeDoc configuration or in the enviroment-variable `CMD_SAML_CLIENTCERT`

## Use Persistent Identifiers
Instead of using the username as the owner-key in the HedgeDoc database, you can also use a persistent identifier. This allows to change the username, without them loosing access to their notes.

1. Go to the HedgeDoc-Client in keycloak. Now enable the option "Force Name ID Format" and select "persistent" as the "Name ID Format".
![keycloak_force_idformat](../../images/auth/keycloak_force_idformat.png)
2. For HedgeDoc to be able to use the username and email configured in keycloak, you have to create the following SAML protocol mappers:
    2.1. Create a mapper with the type `User Property`. Set the Name, Property and SAML Attribute Name to `username`. Now you can specify a friendly name (for example `Username`)
![keycloak_mapper_username](../../images/auth/keycloak_mapper_username.png)
    2.2 Create a mapper with the type `User Property`. Set the Name, Property and SAML Attribute Name to `email`. Now you can specify a friendly name (for example `E-Mail`)
![keycloak_mapper_email](../../images/auth/keycloak_mapper_email.png)

The configured mappers should look like this:
![keycloak_mapper_overview](../../images/auth/keycloak_mapper_overview.png)

3. You now have to add the following block to the saml-definition inside your `config.json`:
```json
"attribute": {
      "username": "username"
      "email": "email",
}
```
It you configure HedgeDoc with enviroment variables, these are the ones you have to set:
```shell
CMD_SAML_ATTRIBUTE_USERNAME=username
CMD_SAML_ATTRIBUTE_EMAIL=email
```
