#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2025 Bernd Schumacher
set -o errexit

###
# The Pillars of the Earth
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250923.5

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='the-pillars-of-the-earth'
GAME_NAME='The Pillars of the Earth'

ARCHIVE_BASE_0_NAME='the_pillars_of_the_earth_en_1_1_703_19574.sh'
ARCHIVE_BASE_0_MD5='1976e6d4476e3d9867aef13176581f58'
ARCHIVE_BASE_0_SIZE='12000000'
ARCHIVE_BASE_0_VERSION='1.1.703-gog19574'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/ken_folletts_the_pillars_of_the_earth_season_pass'

VISIONAIRE_NAME='pillars'

CONTENT_PATH_DEFAULT='data/noarch/game'
## The shipped build of OpenAL must be used, to avoid a missing symbol error:
## symbol lookup error: ./satinav: undefined symbol: SelectResampler
CONTENT_LIBS0_BIN_RELATIVE_PATH='libs64'
CONTENT_LIBS0_BIN_FILES='
libopenal.so'
CONTENT_GAME0_BIN_FILES='
configtool/resources
configtool/translations
configtool/qt.conf
configtool/visconfig'
CONTENT_GAME_DATA_SCENES_FILES='
scenes'
CONTENT_GAME_DATA_COMMON_FILES='
data.vis'

APPLICATIONS_LIST='
APP_MAIN
APP_CONFIG'

## Most properties of the main game launcher are implicit for games relying on the Visionaire engine.
APP_MAIN_ICON='../support/icon.png'

APP_CONFIG_ID="${GAME_ID}-config"
APP_CONFIG_NAME="$GAME_NAME - configuration"
APP_CONFIG_CAT='Settings'
APP_CONFIG_EXE='configtool/visconfig'
APP_CONFIG_ICON='../support/icon.png'


PACKAGES_LIST='
PKG_BIN
PKG_DATA_SCENES
PKG_DATA_COMMON
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libopenal.so.1
libpng12.so.0
libpthread.so.0
libQt5Core.so.5
libQt5Gui.so.5
libQt5Widgets.so.5
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6
libz.so.1'


PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DEPENDENCIES_SIBLINGS='
PKG_DATA_SCENES
PKG_DATA_COMMON'
## Ensure easy upgrades from packages generated by pre-20231005.1 game scripts
PKG_DATA_PROVIDES="${PKG_DATA_PROVIDES:-}
the-pillars-of-the-earth-videos"

PKG_DATA_SCENES_ID="${PKG_DATA_ID}-scenes"
PKG_DATA_SCENES_DESCRIPTION="$PKG_DATA_DESCRIPTION - scenes"

PKG_DATA_COMMON_ID="${PKG_DATA_ID}-common"
PKG_DATA_COMMON_DESCRIPTION="$PKG_DATA_DESCRIPTION - common files between base game and expansion"


# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Link libqxcb.so where the configuration tool expects to find it.

plugin_source="$(path_libraries_system)/qt5/plugins/platforms/libqxcb.so"
plugin_destination="$(package_path 'PKG_BIN')$(path_game_data)/configtool/plugins/platforms/libqxcb.so"
mkdir --parents "$(dirname "$plugin_destination")"
ln --symbolic "$plugin_source" "$plugin_destination"

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
