      SUBROUTINE EMA1D( J, NSCA, SCALAS, PIVOT, DICT, CGV, KGG, CP, F )
C     SUBROUTINE EMA1S( J, NSCA, SCALAS, PIVOT, DICT, CGV, KGG, CP, F )
C*******
C EMA1S ADDS A COLUMN VECTOR IN REAL SINGLE PRECISION
C EMA1D ADDS A COLUMN VECTOR IN REAL DOUBLE PRECISION
C
C     J        INDEX IN SCALAS TO CURRENT RELATIVE COLUMN NBR
C     NSCA     NBR OF ROWS( TERMS ) PER GRID POINT IN COLUMN VECTOR
C     SCALAS   ARRAY OF RELATIVE ROW/COLUMN NUMBERS
C     PIVOT    6-WORD ARRAY AS FOLLOWS...
C          (1) INTERNAL INDEX OF PIVOT
C          (2) DOF OF PIVOT
C          (3) DOF OF EACH POINT CONNECTED TO PIVOT
C          (4) NBR OF CONNECTED POINTS
C          (5) INTERNAL INDEX OF  1ST CONNECTED POINT
C          (6) INTERNAL INDEX OF LAST CONNECTED POINT
C     DICT     DICTIONARY ENTRY FOR ELEMENT AS FOLLOWS...
C          (1) ELEMENT ID
C          (2) FORM( 1=RECT, 2=DIAG )
C          (3) NBR OF TERMS PER COLUMN
C          (4) COMPONENT CODE( DECODED IN SCALAS ARRAY )
C          (5) GE
C          (6) INTERNAL INDEX OF 1ST POINT
C          (7) GINO ADDR OF 1ST COLUMN PARTITION
C         ....
C     CGV      CONNECTED GRID POINT VECTOR
C     KGG      ADDR OF KGG COLUMNS FOR PIVOT
C     CP       ADDR OF COLUMN PARTITION
C     F        FACTOR( RSP ) TO BE APPLIED TO EACH TERM IN CP
C
C******
      INTEGER SCALAS(1) ,PIVOT(6) ,DICT(7)  ,CGV(1)
C
C     REAL             KGG(1), CP(1)
      DOUBLE PRECISION KGG(1), CP(1)
C
C INITIALIZE
C
      ICOL0 = SCALAS(J)*PIVOT(3)*PIVOT(4)
      II0   = PIVOT(5) - 1
      L     = 1
      IF( DICT(2) .NE. 2 ) GO TO 20
C
C PROCESS DIAGONAL PARTITION
C
      II = PIVOT(1)
      IMAT = ICOL0 + CGV(II-II0)+ SCALAS(J)
      KGG(IMAT) = KGG(IMAT) + F*CP(1)
      RETURN
C
C PROCESS RECTANGULAR PARTITION
C
   20 CONTINUE
      NGRID = 4 + 2*DICT(3)/NSCA
      DO 28 I=6,NGRID,2
      K = DICT(I)
      IF( K.EQ. 0 ) RETURN
      IMAT = ICOL0 + CGV(K-II0)
      DO 26 K=1,NSCA
      M = SCALAS(K)
      KGG(IMAT+M) = KGG(IMAT+M) + F*CP(L)
      L = L + 1
   26 CONTINUE
   28 CONTINUE
      RETURN
      END
