import React from 'react';
import PropTypes from 'prop-types';
import { Button, Spinner } from '../../../../index';

var LoginCardSubmitButton = function LoginCardSubmitButton(_ref) {
  var isDisabled = _ref.isDisabled,
      children = _ref.children,
      isLoading = _ref.isLoading;
  return React.createElement(
    Button,
    { className: 'login-pf-submit-button', type: 'submit', bsStyle: 'primary', bsSize: 'large', block: true, disabled: isDisabled },
    children,
    isLoading ? React.createElement(
      'span',
      null,
      ' ',
      React.createElement(Spinner, { loading: isLoading, inline: true, size: 'xs' })
    ) : null
  );
};

LoginCardSubmitButton.propTypes = {
  /** Sets the button disability  */
  isDisabled: PropTypes.bool,
  /** Children nodes */
  children: PropTypes.string,
  /** Sets the spinner visibility */
  isLoading: PropTypes.bool
};

LoginCardSubmitButton.defaultProps = {
  isDisabled: false,
  children: null,
  isLoading: false
};

export default LoginCardSubmitButton;