::
:: 1stlogon.bat
::
::    arranges a Debian Edu/Skolelinux windows profile on the first DOMAIN logon
::
@echo off
setlocal enabledelayedexpansion

if %OS%.==Windows_NT. (

    if EXIST %HOMEDRIVE%\ (

	:: Get windows Version numbers
	for /f "usebackq tokens=2 delims=[]" %%G in (`ver`) do (set _version=%%G)

	echo Windows client version: !_version!
	@echo off
	for /f "usebackq tokens=2,3,4 delims=. " %%G in (`echo !_version!`) do (@set _major=%%G & @set _minor=%%H & @set _build=%%I)
	rem @echo on

	echo Major version: !_major!  Minor Version: !_minor!  Build: !_build!

	if "!_major!" == "4 " goto ver_nt
	if "!_major!" == "5 " goto ver_xp
	if "!_major!" == "6 " goto ver_7

	goto warnthenexit
    )
    goto warnnohomethenexit
)
goto ver_9x

:ver_7
:Run Windows 7 specific commands here.

if EXIST "%HOMEDRIVE%\.ntprofile.V2" (
    if not EXIST "%HOMEDRIVE%\.ntprofile.V2\NTUSER.DAT" (
	echo.
	echo #############################################################################
	echo #
	echo # First logon on domain %USERDOMAIN% under Windows 7 [or similar]
	echo #
	echo #############################################################################
	echo.

	echo Setting up your Windows profile... this will take a little while!!!

	echo.
	echo Creating link to homedirectory...
	start %LOGONSERVER%\netlogon\install\shortcut.vbs
	echo.

	echo Setting up proxy of IE...
	regedit /S %LOGONSERVER%\netlogon\registry\proxy-ie\proxy-settings-hkcu.reg
	echo.

	echo Setting up Firefox profile for MS Windows...
	if not EXIST "%HOMEDRIVE%\.mozilla\firefox\debian-edu-windows.default" (
	    mkdir "%HOMEDRIVE%\.mozilla\firefox\debian-edu-windows.default"
	    xcopy "%HOMEDRIVE%\.mozilla\firefox\debian-edu.default\*" "%HOMEDRIVE%\.mozilla\firefox\debian-edu-windows.default" /Y /C /S
	    copy "%LOGONSERVER%\netlogon\mozilla\firefox\prefs.js" "%HOMEDRIVE%\.mozilla\firefox\debian-edu-windows.default\prefs.js"
	)
	cmd /C %LOGONSERVER%\netlogon\mozilla\mkmozapd.bat
	echo.
    )
)


goto exit

:ver_xp
:Run Windows XP specific commands here.

if EXIST "%HOMEDRIVE%\.ntprofile" (
    if not EXIST "%HOMEDRIVE%\.ntprofile\NTUSER.DAT" (
	echo.
	echo #############################################################################
	echo #
	echo # First logon on domain %USERDOMAIN% under Windows XP [or similar]
	echo #
	echo #############################################################################
	echo.

	echo Setting up your Windows profile... this will take a little while!!!
	echo.

	echo Creating link to homedirectory...
	start %LOGONSERVER%\netlogon\install\shortcut.vbs
	echo.

	echo Setting up proxy of IE...
	regedit /S %LOGONSERVER%\netlogon\registry\proxy-ie\proxy-settings-hkcu.reg
	echo.

	echo Setting up Firefox profile for MS Windows...
	if not EXIST "%HOMEDRIVE%\.mozilla\firefox\debian-edu-windows.default" (
	    mkdir "%HOMEDRIVE%\.mozilla\firefox\debian-edu-windows.default"
	    xcopy "%HOMEDRIVE%\.mozilla\firefox\debian-edu.default\*" "%HOMEDRIVE%\.mozilla\firefox\debian-edu-windows.default" /Y /C /S
	    copy "%LOGONSERVER%\netlogon\mozilla\firefox\prefs.js" "%HOMEDRIVE%\.mozilla\firefox\debian-edu-windows.default\prefs.js"
	)
	cmd /C %LOGONSERVER%\netlogon\mozilla\mkmozapd.bat
	echo.
    )
)

goto exit

:ver_9x
:Run Windows 95/98 specific commands here.
echo WARNING: Windows 9x is not handled by Debian Edu / Skolelinux.
goto exit

:ver_nt
:Run Windows NT specific commands here.
echo WARNING: Windows NT is not handled by Debian Edu / Skolelinux.
goto exit

:warnthenexit
echo WARNING: Machine undetermined.
goto exit

:warnnohomethenexit
echo WARNING: HomeDrive is not available.
goto exit

:exit
endlocal
