#!/bin/bash
#
# Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

# advance mount target

target="/target"
#获取所有没有挂载的设备
devlist=$(lsblk -o TYPE,PATH,MOUNTPOINT | awk '{if($3 == ""){if($1 == "part"){print $2}}}')
devlist=${devlist}
rootPath="";
efiPath="";
bootPath="";
homePath="";
tmpPath="";
varPath="";
srvPath="";
optPath="";
usrLocalPath="";
dataPath="";
recoveryPath="";
swapPath="";

for partition in $devlist; do
    echo $partition
    mount $partition $target
    #根分区判断
    if [ -f ${target}/etc/deepin-version ];then
	 if [ ! -z $rootPath ];then
             umount $target
             echo multiOs > /etc/deepin-repair-tools-os-type.conf
    	     return -1
	 else
	      rootPath=$partition
	      umount $target               
              continue
	 fi
    fi
    umount $target

    #boot分区判断
    mount $partition $target
    if [ -d ${target}/grub ];then	  
	  bootPath=$partition	
	  umount $target 	 
          continue	
    fi
    umount $target

    #efi分区判断
    mount $partition $target
    if [ -d ${target}/EFI ];then
	 umount $target
         efiPath=$partition         
         continue
    fi
    umount $target
    
    #恢复分区判断
    mount $partition $target
    if [ -d ${target}/backup ];then
	 umount $target
         recoveryPath=$partition         
         continue
    fi
    umount $target
    
    #opt分区判断
    mount $partition $target
    if [ -d ${target}/apps ];then
	 umount $target
         optPath=$partition         
         continue
    elif [ -d ${target}/deepinwine ];then
         umount $target
         optPath=$partition         
         continue
    fi
    umount $target

    #var分区判断
    mount $partition $target
    if [ -d ${target}/run ];then
	 umount $target
         varPath=$partition         
         continue
    fi
    umount $target

    #交换分区判断
    mount $partition $target
    swapPatition=$(lsblk -o FSTYPE,PATH | awk '{if($1 == "swap"){if($2 = "$partition"){print $2}}}')   
    if [ ! -z $swapPatition ];then
	 umount $target
         swapPath=$partition         
         continue
    fi
    umount $target
    
done
echo advancedPartition > /etc/deepin-repair-tools-os-type.conf
#获取用户列表
if [ ! -z rootPath ];then
    mount $rootPath $target
    userslist=$(cat ${target}/etc/group)
    umount $target
    for partition in $devlist; do
        if [ "$partition" = "$rootPath" ];then
             continue
        fi

        if [ "$partition" = "$bootPath" ];then
             continue
        fi

        if [ "$partition" = "$efiPath" ];then
             continue
        fi

        if [ "$partition" = "$recoveryPath" ];then
             continue
        fi

        if [ "$partition" = "$swapPatition" ];then
             continue
        fi      
        mount $partition $target
        #判断是否为home
        cd $target 
	dirlist=$(ls -F |grep "/$")
        dirlist=${dirlist}
        for dirName in $dirlist; do
	    dirName=${dirName%*/};
            result=$(echo $userslist | grep $dirName)
	    echo result=$result
	    if [ "$result" != "" ];
		then
		    echo "包含"$dirName
                    homePath=$partition
                    cd /
                    umount $target                    
                    break;
		else
		    echo "不包含"$dirName
		fi
        done
        cd /
        umount $target
             
    done
fi
if [ ! -z $rootPath ];then
   mount $rootPath ${target}
fi

if [ ! -z $bootPath ];then
   mount $bootPath ${target}/boot
fi

if [ ! -z $efiPath ];then
   mount $efiPath ${target}/boot/efi
fi

if [ ! -z $homePath ];then
   mount $homePath ${target}/home
fi

if [ ! -z $tmpPath ];then
   mount $tmpPath ${target}/tmp
fi


if [ ! -z $optPath ];then
    mount $optPath ${target}/opt
fi

if [ ! -z $varPath ]; then
    mount $varPath ${target}/var
fi

if [ ! -z $usrLocalPath ]; then
    mount $usrLocalPath ${target}/usr/local
fi

if [ ! -z $recoveryPath ];then
    mount $recoveryPath ${target}/recovery
fi

if [ ! -z $swapPath ];then
   swapon $swapPath
fi

return 0;
