# deepin 云同步客户端

本文档主要描述需要同步的配置模块，以及每个模块同步信息的获取和设置方法。

对于不同版本的 `DDE` 可能配置文件会有变动，如何处理？


## 数据获取

### Network

按链接类型和文件内容的方式搜集信息，结构如下：

``` json
{
    "type": "wire", // type|wireless|vpn
    "filename": "xxx",
    "contents": ""
}
```

**只搜集无线.**

**GET:** 文件在 `/etc/NetworkManager/system-connections` 中，无线需要去除 `macaddress, interface-name` 等选项

**SET:** 将文件复制到 `/etc/NetworkManager/system-connections`，需要考虑文件冲突

**Notice:** 文件上传到服务器，多个客户端的数据采用合并的算法(文件内容相同但文件不同的如何处理？)


### Audio

目前只同步音效的总开关

**GET:** `gsettings get com.deepin.dde.sound-effect enabled`

**SET:** `gsettings set com.deepin.dde.sound-effect enabled <value>`


### Peripherals

**GET:** `gsettings get com.deepin.dde.[mouse/touchpad] natural-scroll`

**SET:** `gsettings set com.deepin.dde.[mouse/touchpad] natural-scroll <value>`


### Updater

配置在 `/var/lib/lastore/config.json` 中, 包括:

``` go
type Data struct
	AutoCheckUpdates bool `json:"AutoCheckUpdates"`
	AutoDownloadUpdates bool `json:"AutoDownloadUpdates"`
	AutoClean           bool `json:"AutoClean"`
	MirrorSource   string `json:"MirrorSource"`
	AppstoreRegion string `json:"AppstoreRegion"`
}
```

**GET:** 读取文件

**SET:** 通过 `dbus` 接口

监听文件来获取改变


### Dock

- display mode

    **GET:** `gsettings get com.deepin.dde.dock display-mode`

    **SET:** `gsettings set com.deepin.dde.dock display-mode <value>`

- hide mode

    **GET:** `gsettings get com.deepin.dde.dock hide-mode`

    **SET:** `gsettings set com.deepin.dde.dock hide-mode <value>`


- position

    **GET:** `gsettings get com.deepin.dde.dock position`

    **SET:** `gsettings set com.deepin.dde.dock position <value>`


- docked apps

    **GET:** `gsettings get com.deepin.dde.dock docked-apps`, 并通过 `com.deepin.dde.daemon.Dock.GetDockedAppsDesktopFiles` 获取 `app filepath`

    **SET:** `gsettings set com.deepin.dde.dock docked-apps <value>`

    **Notice:** 同步时需要判断应用(`app filepath` 是否存在)是否安装

- icon-size

    **GET:** `gsettings get com.deepin.dde.dock icon-size`

    **SET:** `gsettings set com.deepin.dde.dock icon-size <value>`

- plugins

    通过 `~/.config/deepin/dde-dock.conf` 下的配置文件获取，更改时也是修改这个文件。

    通过监听文件来获取改变。


### Launcher

- 分类模式

    **GET:** `gsettings get com.deepin.dde.launcher display-mode`

    **SET:** `gsettings set com.deepin.dde.launcher display-mode <value>`

- 窗口模式

    **GET:** `gsettings get com.deepin.dde.launcher fullscreen`

    **SET:** `gsettings set com.deepin.dde.launcher fullscreen <value>`


### Appearance

- gtk

    **GET:** `gsettings get com.deepin.dde.appearance gtk-theme`

    **SET:** `gsettings set com.deepin.dde.appearance gtk-theme <value>`

- icon

    **GET:** `gsettings get com.deepin.dde.appearance icon-theme`

    **SET:** `gsettings set com.deepin.dde.appearance icon-theme <value>`


- cursor

    **GET:** `gsettings get com.deepin.dde.appearance cursor-theme`

    **SET:** `gsettings set com.deepin.dde.appearance cursor-theme <value>`


- font

    **GET:** `gsettings get com.deepin.dde.appearance [font-stanard|font-monospace|font-size]`

    **SET:** `gsettings set com.deepin.dde.appearance [font-stanard|font-monospace|font-size] <value>`

**这些在设置之前都需要检查是否存在.**


### background


**GET:** `gsettings get com.deepin.dde.appearance background-uris`

**SET:** `gsettings set com.deepin.dde.appearance background-uris <value>`

同时上传壁纸文件, 壁纸文件以 `workspace%d.<version>` 命名, 每次下载只下载最新的一张


### Screen Edge

**GET:** `gsettings get com.deepin.dde.zone [left-down|left-up|right-down|right-up]`

**SET:** `gsettings set com.deepin.dde.zone [left-down|left-up|right-down|right-up] <value>`

通过 `gsettings` 设置能否立即生效需要测试


## 数据格式

通过上面的选项，确定客户端搜集的数据格式如下：

``` json
{
    "appearance": {
        "font_size": 9,
        "gtk": "Canta",
        "icon": "Papirus",
        "cursor": "deepin",
        "font_standard": "WenQuanYi Micro Hei",
        "font_monospace": "mononoki"
    },
    "background": [
        {
            "filename": "file:///usr/share/wallpapers/deepin/Flowing_Ribbon.jpg",
            "cloud_name": "workspace0.jpg",
            "md5": "a81079fbce908f1f86495f3dac6a46a0"
        },
        {
            "filename": "file:///usr/share/backgrounds/default_background.jpg",
            "cloud_name": "workspace1.jpg",
            "md5": "08cdd22368b034e321eb6d49d19e553a"
        },
        {
            "filename": "file:///usr/share/wallpapers/deepin/Flowing_Ribbon.jpg",
            "cloud_name": "greeter.jpg",
            "md5": "a81079fbce908f1f86495f3dac6a46a0"
        }
    ],
    "dock": {
        "IconSize": 24,
        "DisplayMode": "efficient",
        "HideMode": "keep-showing",
        "Position": "bottom",
        "DockedApps": [
            {
                "Key": "/S@dde-control-center",
                "File": "/usr/share/applications/dde-control-center.desktop"
            },
            {
                "Key": "/L@firefox-beta",
                "File": "/usr/local/share/applications/firefox-beta.desktop"
            },
            {
                "Key": "/S@terminator",
                "File": "/usr/share/applications/terminator.desktop"
            },
            {
                "Key": "/S@netease-cloud-music",
                "File": "/usr/share/applications/netease-cloud-music.desktop"
            }
        ],
        "Plugins": [
            {
                "Name": "datetime",
                "Keys": [
                    {
                        "Key": "pos_1",
                        "Value": "9"
                    }
                ]
            },
            {
                "Name": "shutdown",
                "Keys": [
                    {
                        "Key": "enable",
                        "Value": "false"
                    }
                ]
            },
            {
                "Name": "tray",
                "Keys": [
                    {
                        "Key": "fashion-tray-expanded",
                        "Value": "true"
                    }
                ]
            }
        ]
    },
    "launcher": {
        "display_mode": "category",
        "fullscreen": true
    },
    "network": [
        {
            "type": "wifi",
            "filename": "deepin",
            "contents": "xxx"
        },
        {
            "type": "wifi",
            "filename": "jouyouyun",
            "contents": "xxx"
        }
    ],
    "peripherals": {
        "mouse": {
            "natural_scroll": false
        },
        "touchpad": {
            "natural_scroll": false
        }
    },
    "screen_edge": {
        "left_down": "",
        "left_up": "",
        "right_down": "",
        "right_up": ""
    },
    "audio": {
        "soundeffect": {
            "enabled": false
        }
    },
    "updater": {
        "AutoCheckUpdates": false,
        "AutoDownloadUpdates": false,
        "AutoClean": true,
        "MirrorSource": "default",
        "AppstoreRegion": ""
    }
}
```

上面每个模块还需要加上开关, 关闭同步的就不再上传, 也不更新.

## 总结

根据上面的信息，获取数据的方式为：直接读文件和 `gsettings get` 两种；设置数据的方式为：`dbus` 调用、`gsettings set` 和 文件复制三种。

数据的改变通过监听 `gsettings` 和文件来获取。
