package utils

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"os"
)

type LocalCache struct {
	Version string `json:"version"`
	Data    []byte `json:"data"`
}

const (
	localModuleDir = ".cache/deepin/deepin-sync-daemon/local"
)

func LoadLocalCache(name string, id int64) (*LocalCache, error) {
	dir := fmt.Sprintf("%s/%s/%d", os.Getenv("HOME"), localModuleDir, id)
	filename := fmt.Sprintf("%s/%s.json", dir, name)
	contents, err := ioutil.ReadFile(filename)
	if err != nil {
		return nil, err
	}
	var info LocalCache
	err = json.Unmarshal(contents, &info)
	if err != nil {
		return nil, err
	}
	return &info, nil
}

func SaveLocalCache(name string, id int64, info *LocalCache) error {
	dir := fmt.Sprintf("%s/%s/%d", os.Getenv("HOME"), localModuleDir, id)
	err := os.MkdirAll(dir, 0755)
	if err != nil {
		return err
	}
	data, err := json.Marshal(info)
	if err != nil {
		return err
	}
	return ioutil.WriteFile(fmt.Sprintf("%s/%s.json", dir, name), data, 0644)
}

func DropLocalCache(id int64) error {
	if id == 0 {
		return fmt.Errorf("invalid uid: %d", id)
	}
	dir := fmt.Sprintf("%s/%s/%d", os.Getenv("HOME"), localModuleDir, id)
	return os.RemoveAll(dir)
}
