package appearance

import (
	"reflect"

	Logger "pkg.deepin.io/daemon/sync/infrastructure/log"
	"pkg.deepin.io/daemon/sync/infrastructure/utils"
	. "pkg.deepin.io/daemon/sync/modules/model"
)

const (
	Name = "appearance"
)

type Data struct {
	FontSize      float64 `json:"font_size"`
	GTK           string  `json:"gtk"`
	Icon          string  `json:"icon"`
	Cursor        string  `json:"cursor"`
	FontStandard  string  `json:"font_standard"`
	FontMonospace string  `json:"font_monospace"`
	Version       string  `json:"version"`
}

func (core *Data) Name() string {
	return Name
}

func (core *Data) Model() interface{} {
	return &Data{}
}

func (core *Data) Equal(target DataIFC) bool {
	info := target.(*Data)
	Logger.Debugf("[Appearance Equal] core: %#v", *core)
	Logger.Debugf("[Appearance Equal] target: %#v", *info)
	return reflect.DeepEqual(core, info)
}

func (core *Data) Merge(current, cache DataIFC) {
	curInfo := current.(*Data)
	cacheInfo := cache.(*Data)
	utils.MergeString(&core.GTK, curInfo.GTK, cacheInfo.GTK)
	utils.MergeString(&core.Icon, curInfo.Icon, cacheInfo.Icon)
	utils.MergeString(&core.Cursor, curInfo.Cursor, cacheInfo.Cursor)
	utils.MergeString(&core.FontStandard, curInfo.FontStandard, cacheInfo.FontStandard)
	utils.MergeString(&core.FontMonospace, curInfo.FontMonospace, cacheInfo.FontMonospace)
	utils.MergeFloat64(&core.FontSize, curInfo.FontSize, cacheInfo.FontSize)
}

func (core *Data) GenCache(DataIFC) DataIFC {
	return core
}

func (core *Data) ToIFC(v interface{}) DataIFC {
	return v.(*Data)
}
