package model

// DataIFC module data interface promise
type DataIFC interface {
	Name() string
	Model() interface{}
	Equal(DataIFC) bool
	Merge(DataIFC, DataIFC)
	ToIFC(interface{}) DataIFC
	GenCache(DataIFC) DataIFC
}
type DataIFCList []DataIFC

func (list DataIFCList) Append(name string, info DataIFC) DataIFCList {
	if list.Get(name) != nil {
		return list
	}
	return append(list, info)
}

func (list DataIFCList) Get(name string) DataIFC {
	for _, info := range list {
		if info.Name() == name {
			return info
		}
	}
	return nil
}
