;; Pipeline description for Freescale PowerPC e6500 core.
;;   Copyright (C) 2012-2017 Free Software Foundation, Inc.
;;   Contributed by Edmar Wienskoski (edmar@freescale.com)
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.
;;
;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.
;;
;; e6500 64-bit SFX(2), CFX, LSU, FPU, BU, VSFX, VCFX, VFPU, VPERM
;; Max issue 3 insns/clock cycle (includes 1 branch)

(define_automaton "e6500_most,e6500_long,e6500_vec")
(define_cpu_unit "e6500_decode_0,e6500_decode_1" "e6500_most")

;; SFX.
(define_cpu_unit "e6500_sfx_0,e6500_sfx_1" "e6500_most")

;; CFX.
(define_cpu_unit "e6500_cfx_stage0,e6500_cfx_stage1" "e6500_most")

;; Non-pipelined division.
(define_cpu_unit "e6500_cfx_div" "e6500_long")

;; LSU.
(define_cpu_unit "e6500_lsu" "e6500_most")

;; FPU.
(define_cpu_unit "e6500_fpu" "e6500_long")

;; BU.
(define_cpu_unit "e6500_bu" "e6500_most")

;; Altivec unit
(define_cpu_unit "e6500_vec,e6500_vecperm" "e6500_vec")

;; The following units are used to make the automata deterministic.
(define_cpu_unit "present_e6500_decode_0" "e6500_most")
(define_cpu_unit "present_e6500_sfx_0" "e6500_most")
(presence_set "present_e6500_decode_0" "e6500_decode_0")
(presence_set "present_e6500_sfx_0" "e6500_sfx_0")

;; Some useful abbreviations.
(define_reservation "e6500_decode"
    "e6500_decode_0|e6500_decode_1+present_e6500_decode_0")
(define_reservation "e6500_sfx"
   "e6500_sfx_0|e6500_sfx_1+present_e6500_sfx_0")

;; SFX.
(define_insn_reservation "e6500_sfx" 1
  (and (ior (eq_attr "type" "integer,insert,cntlz")
	    (and (eq_attr "type" "add,logical,exts")
		 (eq_attr "dot"  "no"))
	    (and (eq_attr "type" "shift")
		 (eq_attr "dot"  "no")
		 (eq_attr "var_shift" "no")))
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_sfx")

(define_insn_reservation "e6500_sfx2" 2
  (and (ior (eq_attr "type" "cmp,trap")
	    (and (eq_attr "type" "add,logical,exts")
		 (eq_attr "dot"  "yes"))
	    (and (eq_attr "type" "shift")
		 (eq_attr "dot"  "yes")
		 (eq_attr "var_shift" "no")))
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_sfx")

(define_insn_reservation "e6500_delayed" 2
  (and (eq_attr "type" "shift")
       (eq_attr "var_shift" "yes")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_sfx*2")

(define_insn_reservation "e6500_two" 2
  (and (eq_attr "type" "two")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_decode+e6500_sfx,e6500_sfx")

(define_insn_reservation "e6500_three" 3
  (and (eq_attr "type" "three")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,(e6500_decode+e6500_sfx)*2,e6500_sfx")

;; SFX - Mfcr.
(define_insn_reservation "e6500_mfcr" 4
  (and (eq_attr "type" "mfcr")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_sfx_0*4")

;; SFX - Mtcrf.
(define_insn_reservation "e6500_mtcrf" 1
  (and (eq_attr "type" "mtcr")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_sfx_0")

;; SFX - Mtjmpr.
(define_insn_reservation "e6500_mtjmpr" 1
  (and (eq_attr "type" "mtjmpr,mfjmpr")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_sfx")

;; CFX - Multiply.
(define_insn_reservation "e6500_multiply" 4
  (and (eq_attr "type" "mul")
       (eq_attr "dot" "no")
       (eq_attr "size" "32")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_cfx_stage0,e6500_cfx_stage1")

(define_insn_reservation "e6500_multiply_i" 5
  (and (eq_attr "type" "mul")
       (ior (eq_attr "dot" "yes")
	    (eq_attr "size" "8,16"))
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_cfx_stage0,\
   e6500_cfx_stage0+e6500_cfx_stage1,e6500_cfx_stage1")

;; CFX - Divide.
(define_insn_reservation "e6500_divide" 16
  (and (eq_attr "type" "div")
       (eq_attr "size" "32")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_cfx_stage0+e6500_cfx_div,\
   e6500_cfx_div*15")

(define_insn_reservation "e6500_divide_d" 26
  (and (eq_attr "type" "div")
       (eq_attr "size" "64")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_cfx_stage0+e6500_cfx_div,\
   e6500_cfx_div*25")

;; LSU - Loads.
(define_insn_reservation "e6500_load" 3
  (and (eq_attr "type" "load,load_l,sync")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_lsu")

(define_insn_reservation "e6500_fpload" 4
  (and (eq_attr "type" "fpload")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_lsu")

(define_insn_reservation "e6500_vecload" 4
  (and (eq_attr "type" "vecload")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_lsu")

;; LSU - Stores.
(define_insn_reservation "e6500_store" 3
  (and (eq_attr "type" "store,store_c")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_lsu")

(define_insn_reservation "e6500_fpstore" 3
  (and (eq_attr "type" "fpstore")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_lsu")

(define_insn_reservation "e6500_vecstore" 4
  (and (eq_attr "type" "vecstore")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_lsu")

;; FP.
(define_insn_reservation "e6500_float" 7
  (and (eq_attr "type" "fpsimple,fp,fpcompare,dmul")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_fpu")

(define_insn_reservation "e6500_sdiv" 20
  (and (eq_attr "type" "sdiv")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_fpu*20")

(define_insn_reservation "e6500_ddiv" 35
  (and (eq_attr "type" "ddiv")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_fpu*35")

;; BU.
(define_insn_reservation "e6500_branch" 1
  (and (eq_attr "type" "jmpreg,branch,isync")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_bu")

;; BU - CR logical.
(define_insn_reservation "e6500_cr_logical" 1
  (and (eq_attr "type" "cr_logical,delayed_cr")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_bu")

;; VSFX.
(define_insn_reservation "e6500_vecsimple" 1
  (and (eq_attr "type" "vecsimple,veclogical,vecmove,veccmp,veccmpfx")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_vec")

;; VCFX.
(define_insn_reservation "e6500_veccomplex" 4
  (and (eq_attr "type" "veccomplex")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_vec")

;; VFPU.
(define_insn_reservation "e6500_vecfloat" 6
  (and (eq_attr "type" "vecfloat")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_vec")

;; VPERM.
(define_insn_reservation "e6500_vecperm" 2
  (and (eq_attr "type" "vecperm")
       (eq_attr "cpu" "ppce6500"))
  "e6500_decode,e6500_vecperm")
