// Code generated by "./generator ./org.bluez"; DO NOT EDIT.

package bluez

import (
	"errors"
	"unsafe"

	"github.com/godbus/dbus"
	"github.com/linuxdeepin/go-dbus-factory/object_manager"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type ObjectManager interface {
	object_manager.ObjectManager // interface org.freedesktop.DBus.ObjectManager
	proxy.Object
}

type objectObjectManager struct {
	object_manager.InterfaceObjectManager // interface org.freedesktop.DBus.ObjectManager
	proxy.ImplObject
}

func NewObjectManager(conn *dbus.Conn) ObjectManager {
	obj := new(objectObjectManager)
	obj.ImplObject.Init_(conn, "org.bluez", "/")
	return obj
}

type Manager interface {
	AgentManager() agentManager     // interface org.bluez.AgentManager1
	HealthManager() healthManager   // interface org.bluez.HealthManager1
	ProfileManager() profileManager // interface org.bluez.ProfileManager1
	proxy.Object
}

type objectManager struct {
	interfaceAgentManager   // interface org.bluez.AgentManager1
	interfaceHealthManager  // interface org.bluez.HealthManager1
	interfaceProfileManager // interface org.bluez.ProfileManager1
	proxy.ImplObject
}

func NewManager(conn *dbus.Conn) Manager {
	obj := new(objectManager)
	obj.ImplObject.Init_(conn, "org.bluez", "/org/bluez")
	return obj
}

func (obj *objectManager) AgentManager() agentManager {
	return &obj.interfaceAgentManager
}

type agentManager interface {
	GoRegisterAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath, capability string) *dbus.Call
	RegisterAgent(flags dbus.Flags, agent dbus.ObjectPath, capability string) error
	GoUnregisterAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath) *dbus.Call
	UnregisterAgent(flags dbus.Flags, agent dbus.ObjectPath) error
	GoRequestDefaultAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath) *dbus.Call
	RequestDefaultAgent(flags dbus.Flags, agent dbus.ObjectPath) error
}

type interfaceAgentManager struct{}

func (v *interfaceAgentManager) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceAgentManager) GetInterfaceName_() string {
	return "org.bluez.AgentManager1"
}

// method RegisterAgent

func (v *interfaceAgentManager) GoRegisterAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath, capability string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RegisterAgent", flags, ch, agent, capability)
}

func (v *interfaceAgentManager) RegisterAgent(flags dbus.Flags, agent dbus.ObjectPath, capability string) error {
	return (<-v.GoRegisterAgent(flags, make(chan *dbus.Call, 1), agent, capability).Done).Err
}

// method UnregisterAgent

func (v *interfaceAgentManager) GoUnregisterAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnregisterAgent", flags, ch, agent)
}

func (v *interfaceAgentManager) UnregisterAgent(flags dbus.Flags, agent dbus.ObjectPath) error {
	return (<-v.GoUnregisterAgent(flags, make(chan *dbus.Call, 1), agent).Done).Err
}

// method RequestDefaultAgent

func (v *interfaceAgentManager) GoRequestDefaultAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RequestDefaultAgent", flags, ch, agent)
}

func (v *interfaceAgentManager) RequestDefaultAgent(flags dbus.Flags, agent dbus.ObjectPath) error {
	return (<-v.GoRequestDefaultAgent(flags, make(chan *dbus.Call, 1), agent).Done).Err
}

func (obj *objectManager) HealthManager() healthManager {
	return &obj.interfaceHealthManager
}

type healthManager interface {
	GoCreateApplication(flags dbus.Flags, ch chan *dbus.Call, config map[string]dbus.Variant) *dbus.Call
	CreateApplication(flags dbus.Flags, config map[string]dbus.Variant) (dbus.ObjectPath, error)
	GoDestroyApplication(flags dbus.Flags, ch chan *dbus.Call, application dbus.ObjectPath) *dbus.Call
	DestroyApplication(flags dbus.Flags, application dbus.ObjectPath) error
}

type interfaceHealthManager struct{}

func (v *interfaceHealthManager) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceHealthManager) GetInterfaceName_() string {
	return "org.bluez.HealthManager1"
}

// method CreateApplication

func (v *interfaceHealthManager) GoCreateApplication(flags dbus.Flags, ch chan *dbus.Call, config map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CreateApplication", flags, ch, config)
}

func (*interfaceHealthManager) StoreCreateApplication(call *dbus.Call) (application dbus.ObjectPath, err error) {
	err = call.Store(&application)
	return
}

func (v *interfaceHealthManager) CreateApplication(flags dbus.Flags, config map[string]dbus.Variant) (dbus.ObjectPath, error) {
	return v.StoreCreateApplication(
		<-v.GoCreateApplication(flags, make(chan *dbus.Call, 1), config).Done)
}

// method DestroyApplication

func (v *interfaceHealthManager) GoDestroyApplication(flags dbus.Flags, ch chan *dbus.Call, application dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DestroyApplication", flags, ch, application)
}

func (v *interfaceHealthManager) DestroyApplication(flags dbus.Flags, application dbus.ObjectPath) error {
	return (<-v.GoDestroyApplication(flags, make(chan *dbus.Call, 1), application).Done).Err
}

func (obj *objectManager) ProfileManager() profileManager {
	return &obj.interfaceProfileManager
}

type profileManager interface {
	GoRegisterProfile(flags dbus.Flags, ch chan *dbus.Call, profile dbus.ObjectPath, UUID string, options map[string]dbus.Variant) *dbus.Call
	RegisterProfile(flags dbus.Flags, profile dbus.ObjectPath, UUID string, options map[string]dbus.Variant) error
	GoUnregisterProfile(flags dbus.Flags, ch chan *dbus.Call, profile dbus.ObjectPath) *dbus.Call
	UnregisterProfile(flags dbus.Flags, profile dbus.ObjectPath) error
}

type interfaceProfileManager struct{}

func (v *interfaceProfileManager) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceProfileManager) GetInterfaceName_() string {
	return "org.bluez.ProfileManager1"
}

// method RegisterProfile

func (v *interfaceProfileManager) GoRegisterProfile(flags dbus.Flags, ch chan *dbus.Call, profile dbus.ObjectPath, UUID string, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RegisterProfile", flags, ch, profile, UUID, options)
}

func (v *interfaceProfileManager) RegisterProfile(flags dbus.Flags, profile dbus.ObjectPath, UUID string, options map[string]dbus.Variant) error {
	return (<-v.GoRegisterProfile(flags, make(chan *dbus.Call, 1), profile, UUID, options).Done).Err
}

// method UnregisterProfile

func (v *interfaceProfileManager) GoUnregisterProfile(flags dbus.Flags, ch chan *dbus.Call, profile dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnregisterProfile", flags, ch, profile)
}

func (v *interfaceProfileManager) UnregisterProfile(flags dbus.Flags, profile dbus.ObjectPath) error {
	return (<-v.GoUnregisterProfile(flags, make(chan *dbus.Call, 1), profile).Done).Err
}

type HCI interface {
	Adapter() adapter             // interface org.bluez.Adapter1
	GattManager() gattManager     // interface org.bluez.GattManager1
	Media() media                 // interface org.bluez.Media1
	NetworkServer() networkServer // interface org.bluez.NetworkServer1
	proxy.Object
}

type objectHCI struct {
	interfaceAdapter       // interface org.bluez.Adapter1
	interfaceGattManager   // interface org.bluez.GattManager1
	interfaceMedia         // interface org.bluez.Media1
	interfaceNetworkServer // interface org.bluez.NetworkServer1
	proxy.ImplObject
}

func NewHCI(conn *dbus.Conn, path dbus.ObjectPath) (HCI, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectHCI)
	obj.ImplObject.Init_(conn, "org.bluez", path)
	return obj, nil
}

func (obj *objectHCI) Adapter() adapter {
	return &obj.interfaceAdapter
}

type adapter interface {
	GoStartDiscovery(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	StartDiscovery(flags dbus.Flags) error
	GoSetDiscoveryFilter(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call
	SetDiscoveryFilter(flags dbus.Flags, properties map[string]dbus.Variant) error
	GoStopDiscovery(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	StopDiscovery(flags dbus.Flags) error
	GoRemoveDevice(flags dbus.Flags, ch chan *dbus.Call, device dbus.ObjectPath) *dbus.Call
	RemoveDevice(flags dbus.Flags, device dbus.ObjectPath) error
	Address() proxy.PropString
	Name() proxy.PropString
	Alias() proxy.PropString
	Class() proxy.PropUint32
	Powered() proxy.PropBool
	Discoverable() proxy.PropBool
	DiscoverableTimeout() proxy.PropUint32
	Pairable() proxy.PropBool
	PairableTimeout() proxy.PropUint32
	Discovering() proxy.PropBool
	UUIDs() proxy.PropStringArray
	Modalias() proxy.PropString
}

type interfaceAdapter struct{}

func (v *interfaceAdapter) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceAdapter) GetInterfaceName_() string {
	return "org.bluez.Adapter1"
}

// method StartDiscovery

func (v *interfaceAdapter) GoStartDiscovery(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".StartDiscovery", flags, ch)
}

func (v *interfaceAdapter) StartDiscovery(flags dbus.Flags) error {
	return (<-v.GoStartDiscovery(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method SetDiscoveryFilter

func (v *interfaceAdapter) GoSetDiscoveryFilter(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetDiscoveryFilter", flags, ch, properties)
}

func (v *interfaceAdapter) SetDiscoveryFilter(flags dbus.Flags, properties map[string]dbus.Variant) error {
	return (<-v.GoSetDiscoveryFilter(flags, make(chan *dbus.Call, 1), properties).Done).Err
}

// method StopDiscovery

func (v *interfaceAdapter) GoStopDiscovery(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".StopDiscovery", flags, ch)
}

func (v *interfaceAdapter) StopDiscovery(flags dbus.Flags) error {
	return (<-v.GoStopDiscovery(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method RemoveDevice

func (v *interfaceAdapter) GoRemoveDevice(flags dbus.Flags, ch chan *dbus.Call, device dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RemoveDevice", flags, ch, device)
}

func (v *interfaceAdapter) RemoveDevice(flags dbus.Flags, device dbus.ObjectPath) error {
	return (<-v.GoRemoveDevice(flags, make(chan *dbus.Call, 1), device).Done).Err
}

// property Address s

func (v *interfaceAdapter) Address() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Address",
	}
}

// property Name s

func (v *interfaceAdapter) Name() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Name",
	}
}

// property Alias s

func (v *interfaceAdapter) Alias() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Alias",
	}
}

// property Class u

func (v *interfaceAdapter) Class() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Class",
	}
}

// property Powered b

func (v *interfaceAdapter) Powered() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Powered",
	}
}

// property Discoverable b

func (v *interfaceAdapter) Discoverable() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Discoverable",
	}
}

// property DiscoverableTimeout u

func (v *interfaceAdapter) DiscoverableTimeout() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "DiscoverableTimeout",
	}
}

// property Pairable b

func (v *interfaceAdapter) Pairable() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Pairable",
	}
}

// property PairableTimeout u

func (v *interfaceAdapter) PairableTimeout() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "PairableTimeout",
	}
}

// property Discovering b

func (v *interfaceAdapter) Discovering() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Discovering",
	}
}

// property UUIDs as

func (v *interfaceAdapter) UUIDs() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "UUIDs",
	}
}

// property Modalias s

func (v *interfaceAdapter) Modalias() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Modalias",
	}
}

func (obj *objectHCI) GattManager() gattManager {
	return &obj.interfaceGattManager
}

type gattManager interface {
	GoRegisterApplication(flags dbus.Flags, ch chan *dbus.Call, application dbus.ObjectPath, options map[string]dbus.Variant) *dbus.Call
	RegisterApplication(flags dbus.Flags, application dbus.ObjectPath, options map[string]dbus.Variant) error
	GoUnregisterApplication(flags dbus.Flags, ch chan *dbus.Call, application dbus.ObjectPath) *dbus.Call
	UnregisterApplication(flags dbus.Flags, application dbus.ObjectPath) error
}

type interfaceGattManager struct{}

func (v *interfaceGattManager) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceGattManager) GetInterfaceName_() string {
	return "org.bluez.GattManager1"
}

// method RegisterApplication

func (v *interfaceGattManager) GoRegisterApplication(flags dbus.Flags, ch chan *dbus.Call, application dbus.ObjectPath, options map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RegisterApplication", flags, ch, application, options)
}

func (v *interfaceGattManager) RegisterApplication(flags dbus.Flags, application dbus.ObjectPath, options map[string]dbus.Variant) error {
	return (<-v.GoRegisterApplication(flags, make(chan *dbus.Call, 1), application, options).Done).Err
}

// method UnregisterApplication

func (v *interfaceGattManager) GoUnregisterApplication(flags dbus.Flags, ch chan *dbus.Call, application dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnregisterApplication", flags, ch, application)
}

func (v *interfaceGattManager) UnregisterApplication(flags dbus.Flags, application dbus.ObjectPath) error {
	return (<-v.GoUnregisterApplication(flags, make(chan *dbus.Call, 1), application).Done).Err
}

func (obj *objectHCI) Media() media {
	return &obj.interfaceMedia
}

type media interface {
	GoRegisterEndpoint(flags dbus.Flags, ch chan *dbus.Call, endpoint dbus.ObjectPath, properties map[string]dbus.Variant) *dbus.Call
	RegisterEndpoint(flags dbus.Flags, endpoint dbus.ObjectPath, properties map[string]dbus.Variant) error
	GoUnregisterEndpoint(flags dbus.Flags, ch chan *dbus.Call, endpoint dbus.ObjectPath) *dbus.Call
	UnregisterEndpoint(flags dbus.Flags, endpoint dbus.ObjectPath) error
	GoRegisterPlayer(flags dbus.Flags, ch chan *dbus.Call, player dbus.ObjectPath, properties map[string]dbus.Variant) *dbus.Call
	RegisterPlayer(flags dbus.Flags, player dbus.ObjectPath, properties map[string]dbus.Variant) error
	GoUnregisterPlayer(flags dbus.Flags, ch chan *dbus.Call, player dbus.ObjectPath) *dbus.Call
	UnregisterPlayer(flags dbus.Flags, player dbus.ObjectPath) error
}

type interfaceMedia struct{}

func (v *interfaceMedia) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceMedia) GetInterfaceName_() string {
	return "org.bluez.Media1"
}

// method RegisterEndpoint

func (v *interfaceMedia) GoRegisterEndpoint(flags dbus.Flags, ch chan *dbus.Call, endpoint dbus.ObjectPath, properties map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RegisterEndpoint", flags, ch, endpoint, properties)
}

func (v *interfaceMedia) RegisterEndpoint(flags dbus.Flags, endpoint dbus.ObjectPath, properties map[string]dbus.Variant) error {
	return (<-v.GoRegisterEndpoint(flags, make(chan *dbus.Call, 1), endpoint, properties).Done).Err
}

// method UnregisterEndpoint

func (v *interfaceMedia) GoUnregisterEndpoint(flags dbus.Flags, ch chan *dbus.Call, endpoint dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnregisterEndpoint", flags, ch, endpoint)
}

func (v *interfaceMedia) UnregisterEndpoint(flags dbus.Flags, endpoint dbus.ObjectPath) error {
	return (<-v.GoUnregisterEndpoint(flags, make(chan *dbus.Call, 1), endpoint).Done).Err
}

// method RegisterPlayer

func (v *interfaceMedia) GoRegisterPlayer(flags dbus.Flags, ch chan *dbus.Call, player dbus.ObjectPath, properties map[string]dbus.Variant) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".RegisterPlayer", flags, ch, player, properties)
}

func (v *interfaceMedia) RegisterPlayer(flags dbus.Flags, player dbus.ObjectPath, properties map[string]dbus.Variant) error {
	return (<-v.GoRegisterPlayer(flags, make(chan *dbus.Call, 1), player, properties).Done).Err
}

// method UnregisterPlayer

func (v *interfaceMedia) GoUnregisterPlayer(flags dbus.Flags, ch chan *dbus.Call, player dbus.ObjectPath) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnregisterPlayer", flags, ch, player)
}

func (v *interfaceMedia) UnregisterPlayer(flags dbus.Flags, player dbus.ObjectPath) error {
	return (<-v.GoUnregisterPlayer(flags, make(chan *dbus.Call, 1), player).Done).Err
}

func (obj *objectHCI) NetworkServer() networkServer {
	return &obj.interfaceNetworkServer
}

type networkServer interface {
	GoRegister(flags dbus.Flags, ch chan *dbus.Call, uuid string, bridge string) *dbus.Call
	Register(flags dbus.Flags, uuid string, bridge string) error
	GoUnregister(flags dbus.Flags, ch chan *dbus.Call, uuid string) *dbus.Call
	Unregister(flags dbus.Flags, uuid string) error
}

type interfaceNetworkServer struct{}

func (v *interfaceNetworkServer) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceNetworkServer) GetInterfaceName_() string {
	return "org.bluez.NetworkServer1"
}

// method Register

func (v *interfaceNetworkServer) GoRegister(flags dbus.Flags, ch chan *dbus.Call, uuid string, bridge string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Register", flags, ch, uuid, bridge)
}

func (v *interfaceNetworkServer) Register(flags dbus.Flags, uuid string, bridge string) error {
	return (<-v.GoRegister(flags, make(chan *dbus.Call, 1), uuid, bridge).Done).Err
}

// method Unregister

func (v *interfaceNetworkServer) GoUnregister(flags dbus.Flags, ch chan *dbus.Call, uuid string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Unregister", flags, ch, uuid)
}

func (v *interfaceNetworkServer) Unregister(flags dbus.Flags, uuid string) error {
	return (<-v.GoUnregister(flags, make(chan *dbus.Call, 1), uuid).Done).Err
}

type Device interface {
	device // interface org.bluez.Device1
	proxy.Object
}

type objectDevice struct {
	interfaceDevice // interface org.bluez.Device1
	proxy.ImplObject
}

func NewDevice(conn *dbus.Conn, path dbus.ObjectPath) (Device, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectDevice)
	obj.ImplObject.Init_(conn, "org.bluez", path)
	return obj, nil
}

type device interface {
	GoDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Disconnect(flags dbus.Flags) error
	GoConnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Connect(flags dbus.Flags) error
	GoConnectProfile(flags dbus.Flags, ch chan *dbus.Call, UUID string) *dbus.Call
	ConnectProfile(flags dbus.Flags, UUID string) error
	GoDisconnectProfile(flags dbus.Flags, ch chan *dbus.Call, UUID string) *dbus.Call
	DisconnectProfile(flags dbus.Flags, UUID string) error
	GoPair(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Pair(flags dbus.Flags) error
	GoCancelPairing(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	CancelPairing(flags dbus.Flags) error
	Address() proxy.PropString
	AddressType() proxy.PropString
	Name() proxy.PropString
	Alias() proxy.PropString
	Class() proxy.PropUint32
	Appearance() proxy.PropUint16
	Icon() proxy.PropString
	Paired() proxy.PropBool
	Trusted() proxy.PropBool
	Blocked() proxy.PropBool
	LegacyPairing() proxy.PropBool
	RSSI() proxy.PropInt16
	Connected() proxy.PropBool
	UUIDs() proxy.PropStringArray
	Modalias() proxy.PropString
	Adapter() proxy.PropObjectPath
	ManufacturerData() PropDeviceManufacturerData
	ServiceData() PropDeviceServiceData
	TxPower() proxy.PropInt16
	ServicesResolved() proxy.PropBool
}

type interfaceDevice struct{}

func (v *interfaceDevice) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceDevice) GetInterfaceName_() string {
	return "org.bluez.Device1"
}

// method Disconnect

func (v *interfaceDevice) GoDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Disconnect", flags, ch)
}

func (v *interfaceDevice) Disconnect(flags dbus.Flags) error {
	return (<-v.GoDisconnect(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Connect

func (v *interfaceDevice) GoConnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Connect", flags, ch)
}

func (v *interfaceDevice) Connect(flags dbus.Flags) error {
	return (<-v.GoConnect(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method ConnectProfile

func (v *interfaceDevice) GoConnectProfile(flags dbus.Flags, ch chan *dbus.Call, UUID string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ConnectProfile", flags, ch, UUID)
}

func (v *interfaceDevice) ConnectProfile(flags dbus.Flags, UUID string) error {
	return (<-v.GoConnectProfile(flags, make(chan *dbus.Call, 1), UUID).Done).Err
}

// method DisconnectProfile

func (v *interfaceDevice) GoDisconnectProfile(flags dbus.Flags, ch chan *dbus.Call, UUID string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".DisconnectProfile", flags, ch, UUID)
}

func (v *interfaceDevice) DisconnectProfile(flags dbus.Flags, UUID string) error {
	return (<-v.GoDisconnectProfile(flags, make(chan *dbus.Call, 1), UUID).Done).Err
}

// method Pair

func (v *interfaceDevice) GoPair(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Pair", flags, ch)
}

func (v *interfaceDevice) Pair(flags dbus.Flags) error {
	return (<-v.GoPair(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method CancelPairing

func (v *interfaceDevice) GoCancelPairing(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CancelPairing", flags, ch)
}

func (v *interfaceDevice) CancelPairing(flags dbus.Flags) error {
	return (<-v.GoCancelPairing(flags, make(chan *dbus.Call, 1)).Done).Err
}

// property Address s

func (v *interfaceDevice) Address() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Address",
	}
}

// property AddressType s

func (v *interfaceDevice) AddressType() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "AddressType",
	}
}

// property Name s

func (v *interfaceDevice) Name() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Name",
	}
}

// property Alias s

func (v *interfaceDevice) Alias() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Alias",
	}
}

// property Class u

func (v *interfaceDevice) Class() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Class",
	}
}

// property Appearance q

func (v *interfaceDevice) Appearance() proxy.PropUint16 {
	return &proxy.ImplPropUint16{
		Impl: v,
		Name: "Appearance",
	}
}

// property Icon s

func (v *interfaceDevice) Icon() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Icon",
	}
}

// property Paired b

func (v *interfaceDevice) Paired() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Paired",
	}
}

// property Trusted b

func (v *interfaceDevice) Trusted() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Trusted",
	}
}

// property Blocked b

func (v *interfaceDevice) Blocked() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Blocked",
	}
}

// property LegacyPairing b

func (v *interfaceDevice) LegacyPairing() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "LegacyPairing",
	}
}

// property RSSI n

func (v *interfaceDevice) RSSI() proxy.PropInt16 {
	return &proxy.ImplPropInt16{
		Impl: v,
		Name: "RSSI",
	}
}

// property Connected b

func (v *interfaceDevice) Connected() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Connected",
	}
}

// property UUIDs as

func (v *interfaceDevice) UUIDs() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "UUIDs",
	}
}

// property Modalias s

func (v *interfaceDevice) Modalias() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Modalias",
	}
}

// property Adapter o

func (v *interfaceDevice) Adapter() proxy.PropObjectPath {
	return &proxy.ImplPropObjectPath{
		Impl: v,
		Name: "Adapter",
	}
}

type PropDeviceManufacturerData interface {
	Get(flags dbus.Flags) (value map[uint16]dbus.Variant, err error)
	Set(flags dbus.Flags, value map[uint16]dbus.Variant) error
	ConnectChanged(cb func(hasValue bool, value map[uint16]dbus.Variant)) error
}

type implPropDeviceManufacturerData struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropDeviceManufacturerData) Get(flags dbus.Flags) (value map[uint16]dbus.Variant, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropDeviceManufacturerData) Set(flags dbus.Flags, value map[uint16]dbus.Variant) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropDeviceManufacturerData) ConnectChanged(cb func(hasValue bool, value map[uint16]dbus.Variant)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v map[uint16]dbus.Variant
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property ManufacturerData a{qv}

func (v *interfaceDevice) ManufacturerData() PropDeviceManufacturerData {
	return &implPropDeviceManufacturerData{
		Impl: v,
		Name: "ManufacturerData",
	}
}

type PropDeviceServiceData interface {
	Get(flags dbus.Flags) (value map[string]dbus.Variant, err error)
	Set(flags dbus.Flags, value map[string]dbus.Variant) error
	ConnectChanged(cb func(hasValue bool, value map[string]dbus.Variant)) error
}

type implPropDeviceServiceData struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropDeviceServiceData) Get(flags dbus.Flags) (value map[string]dbus.Variant, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropDeviceServiceData) Set(flags dbus.Flags, value map[string]dbus.Variant) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropDeviceServiceData) ConnectChanged(cb func(hasValue bool, value map[string]dbus.Variant)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v map[string]dbus.Variant
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property ServiceData a{sv}

func (v *interfaceDevice) ServiceData() PropDeviceServiceData {
	return &implPropDeviceServiceData{
		Impl: v,
		Name: "ServiceData",
	}
}

// property TxPower n

func (v *interfaceDevice) TxPower() proxy.PropInt16 {
	return &proxy.ImplPropInt16{
		Impl: v,
		Name: "TxPower",
	}
}

// property ServicesResolved b

func (v *interfaceDevice) ServicesResolved() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "ServicesResolved",
	}
}
