/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pccbase;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import com.dsi.ant.plugins.antplus.pcc.defines.DeviceState;
import com.dsi.ant.plugins.antplus.pcc.defines.DeviceType;
import com.dsi.ant.plugins.antplus.pcc.defines.RequestAccessResult;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.internal.pluginsipc.AntPluginDeviceDbProvider;
import com.dsi.ant.plugins.utility.log.LogAnt;
import com.dsi.ant.plugins.utility.parcel.ParcelPacker;
import com.dsi.ant.plugins.utility.parcel.ParcelUnpacker;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDeviceSearch {
    private static final String TAG = MultiDeviceSearch.class.getSimpleName();
    private final AntPluginPcc.IPluginAccessResultReceiver<SearchPcc> mAccessResultReceiver = new AntPluginPcc.IPluginAccessResultReceiver<SearchPcc>(){

        @Override
        public void onResultReceived(SearchPcc result, RequestAccessResult resultCode, DeviceState initialDeviceState) {
            if (resultCode != RequestAccessResult.SUCCESS) {
                MultiDeviceSearch.this.mCallbacks.onSearchStopped(resultCode);
            }
        }
    };
    private final AntPluginPcc.IDeviceStateChangeReceiver mStateChangeReceiver = new AntPluginPcc.IDeviceStateChangeReceiver(){

        public void onDeviceStateChange(DeviceState newDeviceState) {
        }
    };
    private final SearchPcc mPcc = new SearchPcc();
    private final SearchCallbacks mCallbacks;
    private final RssiCallback mRssiCallback;

    public MultiDeviceSearch(Context context, EnumSet<DeviceType> deviceTypes, SearchCallbacks callbacks, RssiCallback rssiCallback) throws IllegalArgumentException {
        if (context == null || deviceTypes == null || callbacks == null || rssiCallback == null) {
            throw new IllegalArgumentException("Null parameter passed into MultiDeviceSearch constructor");
        }
        this.mCallbacks = callbacks;
        this.mRssiCallback = rssiCallback;
        Bundle params = new Bundle();
        params.putInt("int_RequestAccessMode", 2);
        int[] types = new int[deviceTypes.size()];
        int index = 0;
        for (DeviceType dt : deviceTypes) {
            types[index++] = dt.getIntValue();
        }
        params.putIntArray("intarr_deviceTypeList", types);
        this.mPcc.requestAccess(context, params);
    }

    public void close() {
        this.mPcc.mReleaseHandle.close();
    }

    public String getMissingDependencyPackageName() {
        return AntPluginPcc.getMissingDependencyPackageName();
    }

    public String getMissingDependencyName() {
        return AntPluginPcc.getMissingDependencyName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SearchReleaseHandle
    extends PccReleaseHandle<SearchPcc>
    implements AntPluginPcc.IPluginAccessResultReceiver<SearchPcc>,
    AntPluginPcc.IDeviceStateChangeReceiver {
        protected boolean successReceived;

        public SearchReleaseHandle(AntPluginPcc.IPluginAccessResultReceiver<SearchPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
            super(resultReceiver, stateReceiver);
            this.successReceived = false;
        }

        @Override
        protected void requestCancelled() {
            MultiDeviceSearch.this.mPcc.closePluginConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean isActive() {
            Object object = this.stateLock;
            synchronized (object) {
                return !this.isClosed && (this.resultSent || this.successReceived);
            }
        }

        @Override
        public void onDeviceStateChange(DeviceState newDeviceState) {
            if (newDeviceState == DeviceState.DEAD) {
                this.onResultReceived((SearchPcc)null, RequestAccessResult.OTHER_FAILURE, (DeviceState)null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResultReceived(SearchPcc result, RequestAccessResult resultCode, DeviceState initialDeviceState) {
            Object object = this.stateLock;
            synchronized (object) {
                this.resultSink.onResultReceived(result, resultCode, initialDeviceState);
                if (resultCode == RequestAccessResult.SUCCESS) {
                    this.resultSent = false;
                    this.successReceived = true;
                }
            }
        }
    }

    private class SearchPcc
    extends AntPluginPcc {
        private SearchPcc() {
        }

        private void requestAccess(Context context, Bundle params) {
            SearchReleaseHandle releaser = new SearchReleaseHandle(MultiDeviceSearch.this.mAccessResultReceiver, MultiDeviceSearch.this.mStateChangeReceiver);
            this.mStateChangeReceiver = releaser;
            AntPluginPcc.RequestAccessResultHandler<SearchPcc> resultHandler = new AntPluginPcc.RequestAccessResultHandler<SearchPcc>();
            resultHandler.setReturnInfo(this, releaser);
            this.mReleaseHandle = releaser;
            SearchPcc.requestAccess_Helper_SubMain(context, params, this, resultHandler);
        }

        protected Intent getServiceBindIntent() {
            Intent i = new Intent();
            i.setComponent(new ComponentName("com.dsi.ant.plugins.antplus", "com.dsi.ant.plugins.antplus.multisearch.MultiSearchService"));
            return i;
        }

        protected int getRequiredServiceVersionForBind() {
            return 20205;
        }

        protected void handlePluginEvent(Message eventMsg) {
            switch (eventMsg.arg1) {
                case 1: {
                    Bundle b = eventMsg.getData();
                    b.setClassLoader(MultiDeviceSearchResult.class.getClassLoader());
                    MultiDeviceSearchResult info = (MultiDeviceSearchResult)b.getParcelable("dev_Device");
                    MultiDeviceSearch.this.mCallbacks.onDeviceFound(info);
                    break;
                }
                case 2: {
                    Bundle b = eventMsg.getData();
                    int id = b.getInt("int_resultID");
                    int rssi = b.getInt("int_rssi");
                    MultiDeviceSearch.this.mRssiCallback.onRssiUpdate(id, rssi);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    ((SearchReleaseHandle)this.mReleaseHandle).onResultReceived((SearchPcc)null, RequestAccessResult.getValueFromInt(eventMsg.arg2), (DeviceState)null);
                    MultiDeviceSearch.this.close();
                    break;
                }
                default: {
                    LogAnt.d(TAG, "Unrecognized event received: " + eventMsg.arg1);
                }
            }
        }

        protected String getPluginPrintableName() {
            return "ANT+ Plugin: Multiple Device Search";
        }
    }

    public static interface RssiCallback {
        public void onRssiUpdate(int var1, int var2);
    }

    public static interface SearchCallbacks {
        public void onDeviceFound(MultiDeviceSearchResult var1);

        public void onSearchStopped(RequestAccessResult var1);
    }

    public static class MultiDeviceSearchResult
    implements Parcelable {
        private static final int IPC_VERSION = 1;
        protected final boolean mAlreadyConnected;
        protected final DeviceType mDeviceType;
        protected final AntPluginDeviceDbProvider.DeviceDbDeviceInfo mInfo;
        public final int resultID;
        public static final Parcelable.Creator<MultiDeviceSearchResult> CREATOR = new Parcelable.Creator<MultiDeviceSearchResult>(){

            public MultiDeviceSearchResult[] newArray(int size) {
                return new MultiDeviceSearchResult[size];
            }

            public MultiDeviceSearchResult createFromParcel(Parcel source) {
                return new MultiDeviceSearchResult(source);
            }
        };

        public MultiDeviceSearchResult(int resultID, DeviceType type, AntPluginDeviceDbProvider.DeviceDbDeviceInfo info, boolean alreadyConnected) {
            this.resultID = resultID;
            this.mAlreadyConnected = alreadyConnected;
            this.mDeviceType = type;
            this.mInfo = info;
        }

        public DeviceType getAntDeviceType() {
            return this.mDeviceType;
        }

        public int getAntDeviceNumber() {
            return this.mInfo.antDeviceNumber;
        }

        public boolean isAlreadyConnected() {
            return this.mAlreadyConnected;
        }

        public boolean isPreferredDevice() {
            return this.mInfo.isPreferredDevice;
        }

        public boolean isUserRecognizedDevice() {
            return this.mInfo.device_dbId != null;
        }

        public String getDeviceDisplayName() {
            return this.mInfo.visibleName;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            ParcelPacker packer = new ParcelPacker(dest);
            dest.writeInt(1);
            dest.writeInt(this.resultID);
            dest.writeInt(this.mAlreadyConnected ? 1 : 0);
            dest.writeInt(this.mDeviceType.getIntValue());
            ParcelPacker innerpacker = new ParcelPacker(dest);
            dest.writeParcelable((Parcelable)this.mInfo, flags);
            innerpacker.finish();
            packer.finish();
        }

        protected MultiDeviceSearchResult(Parcel source) {
            ParcelUnpacker unpacker = new ParcelUnpacker(source);
            int ipcVersion = source.readInt();
            if (ipcVersion > 1) {
                LogAnt.w(TAG, "Loading DeviceInfo with ipcVersion " + ipcVersion + " as a version 1 parcel.");
            }
            this.resultID = source.readInt();
            this.mAlreadyConnected = source.readInt() != 0;
            this.mDeviceType = DeviceType.getValueFromInt(source.readInt());
            ParcelUnpacker innerunpack = new ParcelUnpacker(source);
            this.mInfo = (AntPluginDeviceDbProvider.DeviceDbDeviceInfo)source.readParcelable(AntPluginDeviceDbProvider.DeviceDbDeviceInfo.class.getClassLoader());
            innerunpack.finish();
            unpacker.finish();
        }
    }

    public class IpcDefines {
        public static final String PATH_MULTISEARCH_PLUGIN_PKG = "com.dsi.ant.plugins.antplus";
        public static final String PATH_MULTISEARCH_PLUGIN_SERVICE = "com.dsi.ant.plugins.antplus.multisearch.MultiSearchService";
        public static final String REQACC_PARAM_DEVICE_TYPE_LIST = "intarr_deviceTypeList";
        public static final int MSG_EVENT_MULTISEARCH_whatNEWDEVICE = 1;
        public static final String MSG_EVENT_MULTISEARCH_NEWDEVICE_PARAM_DEVICE = "dev_Device";
        public static final int MSG_EVENT_MULTISEARCH_whatRSSIUPDATE = 2;
        public static final String MSG_EVENT_MULTISEARCH_RSSIUPDATE_PARAM_ID = "int_resultID";
        public static final String MSG_EVENT_MULTISEARCH_RSSIUPDATE_PARAM_RSSI = "int_rssi";
        public static final int MSG_EVENT_MULTISEARCH_whatKEEPALIVE = 3;
        public static final int MSG_EVENT_MULTISEARCH_whatSCANSTOPPED = 4;
    }
}

