/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.algorithm;

import jonelo.jacksum.algorithm.AbstractChecksum;

public class Adler32alt
extends AbstractChecksum {
    private static final long BASE = 65521L;

    public Adler32alt() {
        this.reset();
    }

    public void reset() {
        this.value = 1L;
        this.length = 0L;
    }

    public void update(byte[] byArray, int n, int n2) {
        long l = this.value & 0xFFFFL;
        long l2 = this.value >> 16 & 0xFFFFL;
        for (int i = n; i < n2 + n; ++i) {
            l = (l + (long)(byArray[i] & 0xFF)) % 65521L;
            l2 = (l2 + l) % 65521L;
        }
        this.value = l2 << 16 | l;
        this.length += (long)n2;
    }

    public void update(byte by) {
        this.update(new byte[]{by}, 0, 1);
    }

    public void update(int n) {
        this.update((byte)(n & 0xFF));
    }

    public byte[] getByteArray() {
        long l = this.getValue();
        return new byte[]{(byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
    }
}

