; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -fast-isel -mtriple=i386-unknown-unknown -mattr=+sse4.2 | FileCheck %s --check-prefix=ALL --check-prefix=X32
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown-unknown -mattr=+sse4.2 | FileCheck %s --check-prefix=ALL --check-prefix=X64

; NOTE: This should use IR equivalent to what is generated by clang/test/CodeGen/sse42-builtins.c

define i32 @test_mm_cmpestra(<2 x i64> %a0, i32 %a1, <2 x i64> %a2, i32 %a3) nounwind {
; X32-LABEL: test_mm_cmpestra:
; X32:       # %bb.0:
; X32-NEXT:    pushl %ebx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    xorl %ebx, %ebx
; X32-NEXT:    pcmpestri $7, %xmm1, %xmm0
; X32-NEXT:    seta %bl
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    popl %ebx
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cmpestra:
; X64:       # %bb.0:
; X64-NEXT:    xorl %r8d, %r8d
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    movl %esi, %edx
; X64-NEXT:    pcmpestri $7, %xmm1, %xmm0
; X64-NEXT:    seta %r8b
; X64-NEXT:    movl %r8d, %eax
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg2 = bitcast <2 x i64> %a2 to <16 x i8>
  %res = call i32 @llvm.x86.sse42.pcmpestria128(<16 x i8> %arg0, i32 %a1, <16 x i8> %arg2, i32 %a3, i8 7)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestria128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone

define i32 @test_mm_cmpestrc(<2 x i64> %a0, i32 %a1, <2 x i64> %a2, i32 %a3) nounwind {
; X32-LABEL: test_mm_cmpestrc:
; X32:       # %bb.0:
; X32-NEXT:    pushl %ebx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    xorl %ebx, %ebx
; X32-NEXT:    pcmpestri $7, %xmm1, %xmm0
; X32-NEXT:    setb %bl
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    popl %ebx
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cmpestrc:
; X64:       # %bb.0:
; X64-NEXT:    xorl %r8d, %r8d
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    movl %esi, %edx
; X64-NEXT:    pcmpestri $7, %xmm1, %xmm0
; X64-NEXT:    setb %r8b
; X64-NEXT:    movl %r8d, %eax
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg2 = bitcast <2 x i64> %a2 to <16 x i8>
  %res = call i32 @llvm.x86.sse42.pcmpestric128(<16 x i8> %arg0, i32 %a1, <16 x i8> %arg2, i32 %a3, i8 7)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestric128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone

define i32 @test_mm_cmpestri(<2 x i64> %a0, i32 %a1, <2 x i64> %a2, i32 %a3) {
; X32-LABEL: test_mm_cmpestri:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pcmpestri $7, %xmm1, %xmm0
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cmpestri:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    movl %esi, %edx
; X64-NEXT:    pcmpestri $7, %xmm1, %xmm0
; X64-NEXT:    movl %ecx, %eax
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg2 = bitcast <2 x i64> %a2 to <16 x i8>
  %res = call i32 @llvm.x86.sse42.pcmpestri128(<16 x i8> %arg0, i32 %a1, <16 x i8> %arg2, i32 %a3, i8 7)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestri128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone

define <2 x i64> @test_mm_cmpestrm(<2 x i64> %a0, i32 %a1, <2 x i64> %a2, i32 %a3) {
; X32-LABEL: test_mm_cmpestrm:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    pcmpestrm $7, %xmm1, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cmpestrm:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    movl %esi, %edx
; X64-NEXT:    pcmpestrm $7, %xmm1, %xmm0
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg2 = bitcast <2 x i64> %a2 to <16 x i8>
  %res = call <16 x i8> @llvm.x86.sse42.pcmpestrm128(<16 x i8> %arg0, i32 %a1, <16 x i8> %arg2, i32 %a3, i8 7)
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <16 x i8> @llvm.x86.sse42.pcmpestrm128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone

define i32 @test_mm_cmpestro(<2 x i64> %a0, i32 %a1, <2 x i64> %a2, i32 %a3) nounwind {
; X32-LABEL: test_mm_cmpestro:
; X32:       # %bb.0:
; X32-NEXT:    pushl %ebx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    xorl %ebx, %ebx
; X32-NEXT:    pcmpestri $7, %xmm1, %xmm0
; X32-NEXT:    seto %bl
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    popl %ebx
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cmpestro:
; X64:       # %bb.0:
; X64-NEXT:    xorl %r8d, %r8d
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    movl %esi, %edx
; X64-NEXT:    pcmpestri $7, %xmm1, %xmm0
; X64-NEXT:    seto %r8b
; X64-NEXT:    movl %r8d, %eax
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg2 = bitcast <2 x i64> %a2 to <16 x i8>
  %res = call i32 @llvm.x86.sse42.pcmpestrio128(<16 x i8> %arg0, i32 %a1, <16 x i8> %arg2, i32 %a3, i8 7)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestrio128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone

define i32 @test_mm_cmpestrs(<2 x i64> %a0, i32 %a1, <2 x i64> %a2, i32 %a3) nounwind {
; X32-LABEL: test_mm_cmpestrs:
; X32:       # %bb.0:
; X32-NEXT:    pushl %ebx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    xorl %ebx, %ebx
; X32-NEXT:    pcmpestri $7, %xmm1, %xmm0
; X32-NEXT:    sets %bl
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    popl %ebx
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cmpestrs:
; X64:       # %bb.0:
; X64-NEXT:    xorl %r8d, %r8d
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    movl %esi, %edx
; X64-NEXT:    pcmpestri $7, %xmm1, %xmm0
; X64-NEXT:    sets %r8b
; X64-NEXT:    movl %r8d, %eax
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg2 = bitcast <2 x i64> %a2 to <16 x i8>
  %res = call i32 @llvm.x86.sse42.pcmpestris128(<16 x i8> %arg0, i32 %a1, <16 x i8> %arg2, i32 %a3, i8 7)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestris128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone

define i32 @test_mm_cmpestrz(<2 x i64> %a0, i32 %a1, <2 x i64> %a2, i32 %a3) nounwind {
; X32-LABEL: test_mm_cmpestrz:
; X32:       # %bb.0:
; X32-NEXT:    pushl %ebx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    xorl %ebx, %ebx
; X32-NEXT:    pcmpestri $7, %xmm1, %xmm0
; X32-NEXT:    sete %bl
; X32-NEXT:    movl %ebx, %eax
; X32-NEXT:    popl %ebx
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cmpestrz:
; X64:       # %bb.0:
; X64-NEXT:    xorl %r8d, %r8d
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    movl %esi, %edx
; X64-NEXT:    pcmpestri $7, %xmm1, %xmm0
; X64-NEXT:    sete %r8b
; X64-NEXT:    movl %r8d, %eax
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg2 = bitcast <2 x i64> %a2 to <16 x i8>
  %res = call i32 @llvm.x86.sse42.pcmpestriz128(<16 x i8> %arg0, i32 %a1, <16 x i8> %arg2, i32 %a3, i8 7)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestriz128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone

define <2 x i64> @test_mm_cmpgt_epi64(<2 x i64> %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm_cmpgt_epi64:
; X32:       # %bb.0:
; X32-NEXT:    pcmpgtq %xmm1, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cmpgt_epi64:
; X64:       # %bb.0:
; X64-NEXT:    pcmpgtq %xmm1, %xmm0
; X64-NEXT:    retq
  %cmp = icmp sgt <2 x i64> %a0, %a1
  %res = sext <2 x i1> %cmp to <2 x i64>
  ret <2 x i64> %res
}

define i32 @test_mm_cmpistra(<2 x i64> %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm_cmpistra:
; X32:       # %bb.0:
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    pcmpistri $7, %xmm1, %xmm0
; X32-NEXT:    seta %al
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cmpistra:
; X64:       # %bb.0:
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    pcmpistri $7, %xmm1, %xmm0
; X64-NEXT:    seta %al
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = call i32 @llvm.x86.sse42.pcmpistria128(<16 x i8> %arg0, <16 x i8> %arg1, i8 7)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistria128(<16 x i8>, <16 x i8>, i8) nounwind readnone

define i32 @test_mm_cmpistrc(<2 x i64> %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm_cmpistrc:
; X32:       # %bb.0:
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    pcmpistri $7, %xmm1, %xmm0
; X32-NEXT:    setb %al
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cmpistrc:
; X64:       # %bb.0:
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    pcmpistri $7, %xmm1, %xmm0
; X64-NEXT:    setb %al
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = call i32 @llvm.x86.sse42.pcmpistric128(<16 x i8> %arg0, <16 x i8> %arg1, i8 7)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistric128(<16 x i8>, <16 x i8>, i8) nounwind readnone

define i32 @test_mm_cmpistri(<2 x i64> %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm_cmpistri:
; X32:       # %bb.0:
; X32-NEXT:    pcmpistri $7, %xmm1, %xmm0
; X32-NEXT:    movl %ecx, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cmpistri:
; X64:       # %bb.0:
; X64-NEXT:    pcmpistri $7, %xmm1, %xmm0
; X64-NEXT:    movl %ecx, %eax
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = call i32 @llvm.x86.sse42.pcmpistri128(<16 x i8> %arg0, <16 x i8> %arg1, i8 7)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistri128(<16 x i8>, <16 x i8>, i8) nounwind readnone

define <2 x i64> @test_mm_cmpistrm(<2 x i64> %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm_cmpistrm:
; X32:       # %bb.0:
; X32-NEXT:    pcmpistrm $7, %xmm1, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cmpistrm:
; X64:       # %bb.0:
; X64-NEXT:    pcmpistrm $7, %xmm1, %xmm0
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = call <16 x i8> @llvm.x86.sse42.pcmpistrm128(<16 x i8> %arg0, <16 x i8> %arg1, i8 7)
  %bc = bitcast <16 x i8> %res to <2 x i64>
  ret <2 x i64> %bc
}
declare <16 x i8> @llvm.x86.sse42.pcmpistrm128(<16 x i8>, <16 x i8>, i8) nounwind readnone

define i32 @test_mm_cmpistro(<2 x i64> %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm_cmpistro:
; X32:       # %bb.0:
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    pcmpistri $7, %xmm1, %xmm0
; X32-NEXT:    seto %al
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cmpistro:
; X64:       # %bb.0:
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    pcmpistri $7, %xmm1, %xmm0
; X64-NEXT:    seto %al
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = call i32 @llvm.x86.sse42.pcmpistrio128(<16 x i8> %arg0, <16 x i8> %arg1, i8 7)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistrio128(<16 x i8>, <16 x i8>, i8) nounwind readnone

define i32 @test_mm_cmpistrs(<2 x i64> %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm_cmpistrs:
; X32:       # %bb.0:
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    pcmpistri $7, %xmm1, %xmm0
; X32-NEXT:    sets %al
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cmpistrs:
; X64:       # %bb.0:
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    pcmpistri $7, %xmm1, %xmm0
; X64-NEXT:    sets %al
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = call i32 @llvm.x86.sse42.pcmpistris128(<16 x i8> %arg0, <16 x i8> %arg1, i8 7)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistris128(<16 x i8>, <16 x i8>, i8) nounwind readnone

define i32 @test_mm_cmpistrz(<2 x i64> %a0, <2 x i64> %a1) {
; X32-LABEL: test_mm_cmpistrz:
; X32:       # %bb.0:
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    pcmpistri $7, %xmm1, %xmm0
; X32-NEXT:    sete %al
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_cmpistrz:
; X64:       # %bb.0:
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    pcmpistri $7, %xmm1, %xmm0
; X64-NEXT:    sete %al
; X64-NEXT:    retq
  %arg0 = bitcast <2 x i64> %a0 to <16 x i8>
  %arg1 = bitcast <2 x i64> %a1 to <16 x i8>
  %res = call i32 @llvm.x86.sse42.pcmpistriz128(<16 x i8> %arg0, <16 x i8> %arg1, i8 7)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistriz128(<16 x i8>, <16 x i8>, i8) nounwind readnone

define i32 @test_mm_crc32_u8(i32 %a0, i8 %a1) {
; X32-LABEL: test_mm_crc32_u8:
; X32:       # %bb.0:
; X32-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    crc32b %cl, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_crc32_u8:
; X64:       # %bb.0:
; X64-NEXT:    crc32b %sil, %edi
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    retq
  %res = call i32 @llvm.x86.sse42.crc32.32.8(i32 %a0, i8 %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.crc32.32.8(i32, i8) nounwind readnone

define i32 @test_mm_crc32_u16(i32 %a0, i16 %a1) {
; X32-LABEL: test_mm_crc32_u16:
; X32:       # %bb.0:
; X32-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    crc32w %cx, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_crc32_u16:
; X64:       # %bb.0:
; X64-NEXT:    crc32w %si, %edi
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    retq
  %res = call i32 @llvm.x86.sse42.crc32.32.16(i32 %a0, i16 %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.crc32.32.16(i32, i16) nounwind readnone

define i32 @test_mm_crc32_u32(i32 %a0, i32 %a1) {
; X32-LABEL: test_mm_crc32_u32:
; X32:       # %bb.0:
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    crc32l {{[0-9]+}}(%esp), %eax
; X32-NEXT:    retl
;
; X64-LABEL: test_mm_crc32_u32:
; X64:       # %bb.0:
; X64-NEXT:    crc32l %esi, %edi
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    retq
  %res = call i32 @llvm.x86.sse42.crc32.32.32(i32 %a0, i32 %a1)
  ret i32 %res
}
declare i32 @llvm.x86.sse42.crc32.32.32(i32, i32) nounwind readnone
