
# file.py
# write a decision tree to a file, evaluation format

# Copyright (c) 2005 by Matthias Urlichs <smurf@smurf.noris.de>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of Version 2 of the GNU General Public License as
# published by the Free Software Foundation. See the file COPYING.txt
# or (on Debian systems) /usr/share/common-licenses/GPL-2 for details.

"""\
This module prints a decision tree, by writing all the steps to a file.
"""

from keymapper.tree import Reporter
import sys

class FileReporter(Reporter):
	"""Report the result as a list of steps to a file"""
	def __init__(self,file=sys.stdout):
		self.file = file

	def step(self,stepnr):
		"""Start a new step"""
		print >>self.file,"STEP %d" % stepnr

	def keymap(self,map):
		"""This steps selects a unique keymap"""
		print >>self.file,"MAP %s" % map.name
		
	def symbols(self,symbols):
		"""Start a choice: display these symbols"""
		for sym in symbols:
			print >>self.file,"PRESS %s" % sym

	def choice(self,code,nextstep):
		"""Choice: This keycode leads to that step"""
		print >>self.file,"CODE %d %d" % (code,nextstep.step)

	def ask(self,sym,no,yes):
		"""Ask whether that symbol is visible"""
		print >>self.file,"FIND %s" % sym
		print >>self.file,"YES %s" % yes.step
		print >>self.file,"NO %s" % no.step

	def finish(self):
		"""Conclude this step"""
		pass

