<?xml version="1.0"?>
<!--
  Copyright 2002-2004 The Apache Software Foundation or its licensors,
  as applicable.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->
<!-- Transforms a Forrest document into a result tree fragment
     suitable for use by the LuceneIndexTransformer. 

     Note: the result document generated by this stylesheet CANNOT be
     transformed by the LuceneIndexTransformer directly. Aggregation is
     required to assemble several of the lucene:document elements
     (which this stylesheet generates) into one lucene:index root
     element. -->
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:lucene="http://apache.org/cocoon/lucene/1.0"
  version="1.0">

  <!-- The URL of the document which the indexing information stems
  from -->
  <xsl:param name="document-url"/>

  <!-- Creates a lucene:document element, and assigns the url
  attribute as passed in via top-level param -->
  <xsl:template match="/">
    <lucene:document url="{$document-url}">
      <xsl:apply-templates select="document/header" mode="store"/>
      <contents>
        <xsl:apply-templates/>
      </contents>
    </lucene:document>
  </xsl:template>

  <!-- Copies document header, title, and version, and instructs
  Lucene to store the contents of these elements (in addition to
  indexing them) -->
  <xsl:template match="/document/header/title |
                       /document/header/subtitle |
                       /document/header/abstract |
                       /document/header/version"
                mode="store">
    <xsl:element name="{name(.)}">
      <xsl:attribute name="lucene:store">true</xsl:attribute>
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>

  <!-- Copies authors/person, and instructs
  Lucene to store the contents of the person element and to index the
  email and name attributes -->
  <xsl:template match="/document/header/authors/person"
                mode="store">
    <author>
      <xsl:attribute name="lucene:store">true</xsl:attribute>
      <xsl:value-of select="@name"/>
    </author>
  </xsl:template>

  <!-- Everything else from document/header should be ignored -->
  <xsl:template match="/document/header/notice |
                       /document/header/type"
                mode="store">
  </xsl:template>

  <!-- Copies an element and its attributes (text content is handled
  by implicit default template) -->
  <xsl:template match="*">
    <xsl:apply-templates/>
  </xsl:template>
  
</xsl:stylesheet>
