/*
 *  Copyright (c) 2017 The WebM project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */

#ifndef VPX_PORTS_ASMDEFS_MMI_H_
#define VPX_PORTS_ASMDEFS_MMI_H_

#include "./vpx_config.h"
#include "vpx/vpx_integer.h"

#if defined(_ABI64) && _MIPS_SIM == _ABI64
#define mips_reg int64_t
# define PTR_ADDU       "daddu "
# define PTR_ADDIU      "daddiu "
# define PTR_ADDI       "daddi "
# define PTR_SUBU       "dsubu "
# define PTR_L          "ld "
# define PTR_LI         "dli "
# define PTR_S          "sd "
# define PTR_SRA        "dsra "
# define PTR_SRL        "dsrl "
# define PTR_SLL        "dsll "
# define MTC1           "dmtc1 "
#else
#define mips_reg int32_t
# define PTR_ADDU       "addu "
# define PTR_ADDIU      "addiu "
# define PTR_ADDI       "addi "
# define PTR_SUBU       "subu "
# define PTR_L          "lw "
# define PTR_LI         "li "
# define PTR_S          "sw "
# define PTR_SRA        "sra "
# define PTR_SRL        "srl "
# define PTR_SLL        "sll "
# define MTC1           "mtc1 "
#endif

/* Common interface for loongson SIMD optimization */
/* clang-format off */

/**
 * backup register
 */
#define BACKUP_REG \
  double __back_temp[8];                                        \
  if (_MIPS_SIM == _ABI64)                                      \
    __asm__ volatile (                                          \
      "gssqc1       $f25,      $f24,       0x00(%[temp])  \n\t" \
      "gssqc1       $f27,      $f26,       0x10(%[temp])  \n\t" \
      "gssqc1       $f29,      $f28,       0x20(%[temp])  \n\t" \
      "gssqc1       $f31,      $f30,       0x30(%[temp])  \n\t" \
      :                                                         \
      : [temp]"r"(__back_temp)                                  \
      : "memory"                                                \
    );                                                          \
  else                                                          \
    __asm__ volatile (                                          \
      "gssqc1       $f22,      $f20,       0x00(%[temp])  \n\t" \
      "gssqc1       $f26,      $f24,       0x10(%[temp])  \n\t" \
      "gssqc1       $f30,      $f28,       0x20(%[temp])  \n\t" \
      :                                                         \
      : [temp]"r"(__back_temp)                                  \
      : "memory"                                                \
    );

/**
 * recover register
 */
#define RECOVER_REG \
  if (_MIPS_SIM == _ABI64)                                      \
    __asm__ volatile (                                          \
      "gslqc1       $f25,      $f24,       0x00(%[temp])  \n\t" \
      "gslqc1       $f27,      $f26,       0x10(%[temp])  \n\t" \
      "gslqc1       $f29,      $f28,       0x20(%[temp])  \n\t" \
      "gslqc1       $f31,      $f30,       0x30(%[temp])  \n\t" \
      :                                                         \
      : [temp]"r"(__back_temp)                                  \
      : "memory"                                                \
    );                                                          \
  else                                                          \
    __asm__ volatile (                                          \
      "gslqc1       $f22,      $f20,       0x00(%[temp])  \n\t" \
      "gslqc1       $f26,      $f24,       0x10(%[temp])  \n\t" \
      "gslqc1       $f30,      $f28,       0x20(%[temp])  \n\t" \
      :                                                         \
      : [temp]"r"(__back_temp)                                  \
      : "memory"                                                \
    );

/**
 * brief: Transpose 4X4 half word packaged data.
 * fr_i0, fr_i1, fr_i2, fr_i3: src & dst
 * fr_t0~t6, r_t0: temporary register
 */
#define MMI_TRANSPOSE_4H(fr_i0, fr_i1, fr_i2, fr_i3,            \
                         fr_t0, fr_t1, fr_t2, fr_t3)            \
  "punpcklhw    "#fr_t0",   "#fr_i0",   "#fr_i1"          \n\t" \
  "punpckhhw    "#fr_t1",   "#fr_i0",   "#fr_i1"          \n\t" \
  "punpcklhw    "#fr_t2",   "#fr_i2",   "#fr_i3"          \n\t" \
  "punpckhhw    "#fr_t3",   "#fr_i2",   "#fr_i3"          \n\t" \
  "punpcklwd    "#fr_i0",   "#fr_t0",   "#fr_t2"          \n\t" \
  "punpckhwd    "#fr_i1",   "#fr_t0",   "#fr_t2"          \n\t" \
  "punpcklwd    "#fr_i2",   "#fr_t1",   "#fr_t3"          \n\t" \
  "punpckhwd    "#fr_i3",   "#fr_t1",   "#fr_t3"          \n\t"

/* clang-format on */
#endif /* VPX_PORTS_ASMDEFS_MMI_H_ */
