// license:BSD-3-Clause
// copyright-holders:Bryan McPhail

const nec_common_device::nec_ophandler nec_common_device::s_nec_instruction[256] =
{
	&nec_common_device::i_add_br8,      /* 0x00 */
	&nec_common_device::i_add_wr16,     /* 0x01 */
	&nec_common_device::i_add_r8b,      /* 0x02 */
	&nec_common_device::i_add_r16w,     /* 0x03 */
	&nec_common_device::i_add_ald8,     /* 0x04 */
	&nec_common_device::i_add_axd16,    /* 0x05 */
	&nec_common_device::i_push_es,      /* 0x06 */
	&nec_common_device::i_pop_es,       /* 0x07 */
	&nec_common_device::i_or_br8,       /* 0x08 */
	&nec_common_device::i_or_wr16,      /* 0x09 */
	&nec_common_device::i_or_r8b,       /* 0x0a */
	&nec_common_device::i_or_r16w,      /* 0x0b */
	&nec_common_device::i_or_ald8,      /* 0x0c */
	&nec_common_device::i_or_axd16,     /* 0x0d */
	&nec_common_device::i_push_cs,      /* 0x0e */
	&nec_common_device::i_pre_nec,      /* 0x0f */
	&nec_common_device::i_adc_br8,      /* 0x10 */
	&nec_common_device::i_adc_wr16,     /* 0x11 */
	&nec_common_device::i_adc_r8b,      /* 0x12 */
	&nec_common_device::i_adc_r16w,     /* 0x13 */
	&nec_common_device::i_adc_ald8,     /* 0x14 */
	&nec_common_device::i_adc_axd16,    /* 0x15 */
	&nec_common_device::i_push_ss,      /* 0x16 */
	&nec_common_device::i_pop_ss,       /* 0x17 */
	&nec_common_device::i_sbb_br8,      /* 0x18 */
	&nec_common_device::i_sbb_wr16,     /* 0x19 */
	&nec_common_device::i_sbb_r8b,      /* 0x1a */
	&nec_common_device::i_sbb_r16w,     /* 0x1b */
	&nec_common_device::i_sbb_ald8,     /* 0x1c */
	&nec_common_device::i_sbb_axd16,    /* 0x1d */
	&nec_common_device::i_push_ds,      /* 0x1e */
	&nec_common_device::i_pop_ds,       /* 0x1f */
	&nec_common_device::i_and_br8,      /* 0x20 */
	&nec_common_device::i_and_wr16,     /* 0x21 */
	&nec_common_device::i_and_r8b,      /* 0x22 */
	&nec_common_device::i_and_r16w,     /* 0x23 */
	&nec_common_device::i_and_ald8,     /* 0x24 */
	&nec_common_device::i_and_axd16,    /* 0x25 */
	&nec_common_device::i_es,           /* 0x26 */
	&nec_common_device::i_daa,          /* 0x27 */
	&nec_common_device::i_sub_br8,      /* 0x28 */
	&nec_common_device::i_sub_wr16,     /* 0x29 */
	&nec_common_device::i_sub_r8b,      /* 0x2a */
	&nec_common_device::i_sub_r16w,     /* 0x2b */
	&nec_common_device::i_sub_ald8,     /* 0x2c */
	&nec_common_device::i_sub_axd16,    /* 0x2d */
	&nec_common_device::i_cs,           /* 0x2e */
	&nec_common_device::i_das,          /* 0x2f */
	&nec_common_device::i_xor_br8,      /* 0x30 */
	&nec_common_device::i_xor_wr16,     /* 0x31 */
	&nec_common_device::i_xor_r8b,      /* 0x32 */
	&nec_common_device::i_xor_r16w,     /* 0x33 */
	&nec_common_device::i_xor_ald8,     /* 0x34 */
	&nec_common_device::i_xor_axd16,    /* 0x35 */
	&nec_common_device::i_ss,           /* 0x36 */
	&nec_common_device::i_aaa,          /* 0x37 */
	&nec_common_device::i_cmp_br8,      /* 0x38 */
	&nec_common_device::i_cmp_wr16,     /* 0x39 */
	&nec_common_device::i_cmp_r8b,      /* 0x3a */
	&nec_common_device::i_cmp_r16w,     /* 0x3b */
	&nec_common_device::i_cmp_ald8,     /* 0x3c */
	&nec_common_device::i_cmp_axd16,    /* 0x3d */
	&nec_common_device::i_ds,           /* 0x3e */
	&nec_common_device::i_aas,          /* 0x3f */
	&nec_common_device::i_inc_ax,       /* 0x40 */
	&nec_common_device::i_inc_cx,       /* 0x41 */
	&nec_common_device::i_inc_dx,       /* 0x42 */
	&nec_common_device::i_inc_bx,       /* 0x43 */
	&nec_common_device::i_inc_sp,       /* 0x44 */
	&nec_common_device::i_inc_bp,       /* 0x45 */
	&nec_common_device::i_inc_si,       /* 0x46 */
	&nec_common_device::i_inc_di,       /* 0x47 */
	&nec_common_device::i_dec_ax,       /* 0x48 */
	&nec_common_device::i_dec_cx,       /* 0x49 */
	&nec_common_device::i_dec_dx,       /* 0x4a */
	&nec_common_device::i_dec_bx,       /* 0x4b */
	&nec_common_device::i_dec_sp,       /* 0x4c */
	&nec_common_device::i_dec_bp,       /* 0x4d */
	&nec_common_device::i_dec_si,       /* 0x4e */
	&nec_common_device::i_dec_di,       /* 0x4f */
	&nec_common_device::i_push_ax,      /* 0x50 */
	&nec_common_device::i_push_cx,      /* 0x51 */
	&nec_common_device::i_push_dx,      /* 0x52 */
	&nec_common_device::i_push_bx,      /* 0x53 */
	&nec_common_device::i_push_sp,      /* 0x54 */
	&nec_common_device::i_push_bp,      /* 0x55 */
	&nec_common_device::i_push_si,      /* 0x56 */
	&nec_common_device::i_push_di,      /* 0x57 */
	&nec_common_device::i_pop_ax,       /* 0x58 */
	&nec_common_device::i_pop_cx,       /* 0x59 */
	&nec_common_device::i_pop_dx,       /* 0x5a */
	&nec_common_device::i_pop_bx,       /* 0x5b */
	&nec_common_device::i_pop_sp,       /* 0x5c */
	&nec_common_device::i_pop_bp,       /* 0x5d */
	&nec_common_device::i_pop_si,       /* 0x5e */
	&nec_common_device::i_pop_di,       /* 0x5f */
	&nec_common_device::i_pusha,        /* 0x60 */
	&nec_common_device::i_popa,         /* 0x61 */
	&nec_common_device::i_chkind,       /* 0x62 */
	&nec_common_device::i_invalid,      /* 0x63 */
	&nec_common_device::i_repnc,        /* 0x64 */
	&nec_common_device::i_repc,         /* 0x65 */
	&nec_common_device::i_invalid,      /* 0x66 */
	&nec_common_device::i_invalid,      /* 0x67 */
	&nec_common_device::i_push_d16,     /* 0x68 */
	&nec_common_device::i_imul_d16,     /* 0x69 */
	&nec_common_device::i_push_d8,      /* 0x6a */
	&nec_common_device::i_imul_d8,      /* 0x6b */
	&nec_common_device::i_insb,         /* 0x6c */
	&nec_common_device::i_insw,         /* 0x6d */
	&nec_common_device::i_outsb,        /* 0x6e */
	&nec_common_device::i_outsw,        /* 0x6f */
	&nec_common_device::i_jo,           /* 0x70 */
	&nec_common_device::i_jno,          /* 0x71 */
	&nec_common_device::i_jc,           /* 0x72 */
	&nec_common_device::i_jnc,          /* 0x73 */
	&nec_common_device::i_jz,           /* 0x74 */
	&nec_common_device::i_jnz,          /* 0x75 */
	&nec_common_device::i_jce,          /* 0x76 */
	&nec_common_device::i_jnce,         /* 0x77 */
	&nec_common_device::i_js,           /* 0x78 */
	&nec_common_device::i_jns,          /* 0x79 */
	&nec_common_device::i_jp,           /* 0x7a */
	&nec_common_device::i_jnp,          /* 0x7b */
	&nec_common_device::i_jl,           /* 0x7c */
	&nec_common_device::i_jnl,          /* 0x7d */
	&nec_common_device::i_jle,          /* 0x7e */
	&nec_common_device::i_jnle,         /* 0x7f */
	&nec_common_device::i_80pre,        /* 0x80 */
	&nec_common_device::i_81pre,        /* 0x81 */
	&nec_common_device::i_82pre,        /* 0x82 */
	&nec_common_device::i_83pre,        /* 0x83 */
	&nec_common_device::i_test_br8,     /* 0x84 */
	&nec_common_device::i_test_wr16,    /* 0x85 */
	&nec_common_device::i_xchg_br8,     /* 0x86 */
	&nec_common_device::i_xchg_wr16,    /* 0x87 */
	&nec_common_device::i_mov_br8,      /* 0x88 */
	&nec_common_device::i_mov_wr16,     /* 0x89 */
	&nec_common_device::i_mov_r8b,      /* 0x8a */
	&nec_common_device::i_mov_r16w,     /* 0x8b */
	&nec_common_device::i_mov_wsreg,    /* 0x8c */
	&nec_common_device::i_lea,          /* 0x8d */
	&nec_common_device::i_mov_sregw,    /* 0x8e */
	&nec_common_device::i_popw,         /* 0x8f */
	&nec_common_device::i_nop,          /* 0x90 */
	&nec_common_device::i_xchg_axcx,    /* 0x91 */
	&nec_common_device::i_xchg_axdx,    /* 0x92 */
	&nec_common_device::i_xchg_axbx,    /* 0x93 */
	&nec_common_device::i_xchg_axsp,    /* 0x94 */
	&nec_common_device::i_xchg_axbp,    /* 0x95 */
	&nec_common_device::i_xchg_axsi,    /* 0x96 */
	&nec_common_device::i_xchg_axdi,    /* 0x97 */
	&nec_common_device::i_cbw,          /* 0x98 */
	&nec_common_device::i_cwd,          /* 0x99 */
	&nec_common_device::i_call_far,     /* 0x9a */
	&nec_common_device::i_wait,         /* 0x9b */
	&nec_common_device::i_pushf,        /* 0x9c */
	&nec_common_device::i_popf,         /* 0x9d */
	&nec_common_device::i_sahf,         /* 0x9e */
	&nec_common_device::i_lahf,         /* 0x9f */
	&nec_common_device::i_mov_aldisp,   /* 0xa0 */
	&nec_common_device::i_mov_axdisp,   /* 0xa1 */
	&nec_common_device::i_mov_dispal,   /* 0xa2 */
	&nec_common_device::i_mov_dispax,   /* 0xa3 */
	&nec_common_device::i_movsb,        /* 0xa4 */
	&nec_common_device::i_movsw,        /* 0xa5 */
	&nec_common_device::i_cmpsb,        /* 0xa6 */
	&nec_common_device::i_cmpsw,        /* 0xa7 */
	&nec_common_device::i_test_ald8,    /* 0xa8 */
	&nec_common_device::i_test_axd16,   /* 0xa9 */
	&nec_common_device::i_stosb,        /* 0xaa */
	&nec_common_device::i_stosw,        /* 0xab */
	&nec_common_device::i_lodsb,        /* 0xac */
	&nec_common_device::i_lodsw,        /* 0xad */
	&nec_common_device::i_scasb,        /* 0xae */
	&nec_common_device::i_scasw,        /* 0xaf */
	&nec_common_device::i_mov_ald8,     /* 0xb0 */
	&nec_common_device::i_mov_cld8,     /* 0xb1 */
	&nec_common_device::i_mov_dld8,     /* 0xb2 */
	&nec_common_device::i_mov_bld8,     /* 0xb3 */
	&nec_common_device::i_mov_ahd8,     /* 0xb4 */
	&nec_common_device::i_mov_chd8,     /* 0xb5 */
	&nec_common_device::i_mov_dhd8,     /* 0xb6 */
	&nec_common_device::i_mov_bhd8,     /* 0xb7 */
	&nec_common_device::i_mov_axd16,    /* 0xb8 */
	&nec_common_device::i_mov_cxd16,    /* 0xb9 */
	&nec_common_device::i_mov_dxd16,    /* 0xba */
	&nec_common_device::i_mov_bxd16,    /* 0xbb */
	&nec_common_device::i_mov_spd16,    /* 0xbc */
	&nec_common_device::i_mov_bpd16,    /* 0xbd */
	&nec_common_device::i_mov_sid16,    /* 0xbe */
	&nec_common_device::i_mov_did16,    /* 0xbf */
	&nec_common_device::i_rotshft_bd8,  /* 0xc0 */
	&nec_common_device::i_rotshft_wd8,  /* 0xc1 */
	&nec_common_device::i_ret_d16,      /* 0xc2 */
	&nec_common_device::i_ret,          /* 0xc3 */
	&nec_common_device::i_les_dw,       /* 0xc4 */
	&nec_common_device::i_lds_dw,       /* 0xc5 */
	&nec_common_device::i_mov_bd8,      /* 0xc6 */
	&nec_common_device::i_mov_wd16,     /* 0xc7 */
	&nec_common_device::i_enter,        /* 0xc8 */
	&nec_common_device::i_leave,        /* 0xc9 */
	&nec_common_device::i_retf_d16,     /* 0xca */
	&nec_common_device::i_retf,         /* 0xcb */
	&nec_common_device::i_int3,         /* 0xcc */
	&nec_common_device::i_int,          /* 0xcd */
	&nec_common_device::i_into,         /* 0xce */
	&nec_common_device::i_iret,         /* 0xcf */
	&nec_common_device::i_rotshft_b,    /* 0xd0 */
	&nec_common_device::i_rotshft_w,    /* 0xd1 */
	&nec_common_device::i_rotshft_bcl,  /* 0xd2 */
	&nec_common_device::i_rotshft_wcl,  /* 0xd3 */
	&nec_common_device::i_aam,          /* 0xd4 */
	&nec_common_device::i_aad,          /* 0xd5 */
	&nec_common_device::i_setalc,       /* 0xd6 */
	&nec_common_device::i_trans,        /* 0xd7 */
	&nec_common_device::i_fpo,          /* 0xd8 */
	&nec_common_device::i_fpo,          /* 0xd9 */
	&nec_common_device::i_fpo,          /* 0xda */
	&nec_common_device::i_fpo,          /* 0xdb */
	&nec_common_device::i_fpo,          /* 0xdc */
	&nec_common_device::i_fpo,          /* 0xdd */
	&nec_common_device::i_fpo,          /* 0xde */
	&nec_common_device::i_fpo,          /* 0xdf */
	&nec_common_device::i_loopne,       /* 0xe0 */
	&nec_common_device::i_loope,        /* 0xe1 */
	&nec_common_device::i_loop,         /* 0xe2 */
	&nec_common_device::i_jcxz,         /* 0xe3 */
	&nec_common_device::i_inal,         /* 0xe4 */
	&nec_common_device::i_inax,         /* 0xe5 */
	&nec_common_device::i_outal,        /* 0xe6 */
	&nec_common_device::i_outax,        /* 0xe7 */
	&nec_common_device::i_call_d16,     /* 0xe8 */
	&nec_common_device::i_jmp_d16,      /* 0xe9 */
	&nec_common_device::i_jmp_far,      /* 0xea */
	&nec_common_device::i_jmp_d8,       /* 0xeb */
	&nec_common_device::i_inaldx,       /* 0xec */
	&nec_common_device::i_inaxdx,       /* 0xed */
	&nec_common_device::i_outdxal,      /* 0xee */
	&nec_common_device::i_outdxax,      /* 0xef */
	&nec_common_device::i_lock,         /* 0xf0 */
	&nec_common_device::i_invalid,      /* 0xf1 */
	&nec_common_device::i_repne,        /* 0xf2 */
	&nec_common_device::i_repe,         /* 0xf3 */
	&nec_common_device::i_hlt,          /* 0xf4 */
	&nec_common_device::i_cmc,          /* 0xf5 */
	&nec_common_device::i_f6pre,        /* 0xf6 */
	&nec_common_device::i_f7pre,        /* 0xf7 */
	&nec_common_device::i_clc,          /* 0xf8 */
	&nec_common_device::i_stc,          /* 0xf9 */
	&nec_common_device::i_di,           /* 0xfa */
	&nec_common_device::i_ei,           /* 0xfb */
	&nec_common_device::i_cld,          /* 0xfc */
	&nec_common_device::i_std,          /* 0xfd */
	&nec_common_device::i_fepre,        /* 0xfe */
	&nec_common_device::i_ffpre         /* 0xff */
};
