// This C++ file is the interface between GNU/Octave and Psychtoolbox
// module WaitSecs. It defines the entry-point function FWaitSecs and the online
// help for WaitSecs. The function itself (see bottom of file) is just a
// wrapper around octFunction(), the real command dispatcher defined in
// the PsychScriptingGlue.cc file.
// This file is autogenerated, please do not edit!
//

#ifdef PTBOCTAVE
#define PTBMODULE_WaitSecs
#include <octave/oct.h>

extern "C" {
  // mex.cc names both mexFunction (c) and MEXFUNCTION (Fortran)
  // but the mex file only defines one of them, so define the other
  // here just to keep the linker happy, but don't ever call it.
  void F77_FUNC(mexfunction,MEXFUNCTION)() {}
  const char *mexFunctionName = "WaitSecs";
} ;

DEFUN_DLD(WaitSecs, args, nargout,
"\
 WaitSecs(s)\n\
\n\
 Waits \"s\" seconds with high precision.  The timing precision  depends on\n\
 the model of your computer, but a well configured system will be accurate\n\
 to about 1 millisecond if your script is executed with realtime-priority\n\
 (See help Priority) and well written.\n\
 \n\
 WaitSecs(s) is similar to Matlab's built-in PAUSE(s) command. The\n\
 advantage of WaitSecs(s) is that it is much more accurate. However, PAUSE\n\
 can be turned 'ON' and 'OFF', which is useful for scripts.\n\
 \n\
 TIMING ADVICE: the first time you access any MEX function or M file,\n\
 Matlab takes several hundred milliseconds to load it from disk.\n\
 Allocating a variable takes time too. Usually you'll want to omit those\n\
 delays from your timing measurements by making sure all the functions you\n\
 use are loaded and that all the variables you use are allocated, before\n\
 you start timing. MEX files stay loaded until you flush the MEX files\n\
 (e.g. by changing directory or calling CLEAR MEX). M files and variables\n\
 stay in memory until you clear them.\n\
\n\
 OS X: ___________________________________________________________________\n\
\n\
 WaitSecs always uses the high-precision uptime clock.  It sleeps the main\n\
 MATLAB thread for the given wait period, surrendering CPU time to other\n\
 processes while waiting.  WaitSecs is now safe to use at any priority\n\
 setting.  \n\
\n\
 WaitSecs ignores the OX MATLAB <ctrl>-C break key sequenece.\n\
\n\
 WINDOWS:_________________________________________________________________\n\
\n\
 WaitSecs uses  Windows QueryPerformanceCounter() call which, in turn, \n\
 reads a high-performance hardware counter in Pentium and better CPUs.\n\
\n\
 WaitSecs ignores the Win MATLAB <ctrl>-C break key sequenece.\n\
\n\
 _________________________________________________________________________\n\
 \n\
 See also: GetSecs, GetSecsTick, GetTicks, WaitTicks, PAUSE.\n\
")
{
  octave_value_list octFunction(const octave_value_list &, const int);
  return octFunction(args, nargout);
}
#endif

