# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SiteLimits(Model):
    """Metric limits set on an app.

    :param max_percentage_cpu: Maximum allowed CPU usage percentage.
    :type max_percentage_cpu: float
    :param max_memory_in_mb: Maximum allowed memory usage in MB.
    :type max_memory_in_mb: long
    :param max_disk_size_in_mb: Maximum allowed disk size usage in MB.
    :type max_disk_size_in_mb: long
    """

    _attribute_map = {
        'max_percentage_cpu': {'key': 'maxPercentageCpu', 'type': 'float'},
        'max_memory_in_mb': {'key': 'maxMemoryInMb', 'type': 'long'},
        'max_disk_size_in_mb': {'key': 'maxDiskSizeInMb', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(SiteLimits, self).__init__(**kwargs)
        self.max_percentage_cpu = kwargs.get('max_percentage_cpu', None)
        self.max_memory_in_mb = kwargs.get('max_memory_in_mb', None)
        self.max_disk_size_in_mb = kwargs.get('max_disk_size_in_mb', None)
