# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .repair_target_description_base_py3 import RepairTargetDescriptionBase


class NodeRepairTargetDescription(RepairTargetDescriptionBase):
    """Describes the list of nodes targeted by a repair action.
    This type supports the Service Fabric platform; it is not meant to be used
    directly from your code.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param node_names: The list of nodes targeted by a repair action.
    :type node_names: list[str]
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'node_names': {'key': 'NodeNames', 'type': '[str]'},
    }

    def __init__(self, *, node_names=None, **kwargs) -> None:
        super(NodeRepairTargetDescription, self).__init__(**kwargs)
        self.node_names = node_names
        self.kind = 'Node'
