// Copyright (c) 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is auto-generated from
//    gpu/config/process_json.py
// It's formatted by clang-format using chromium coding style:
//    clang-format -i -style=chromium filename
// DO NOT EDIT!

#include "content/browser/gpu/gpu_data_manager_testing_autogen.h"

#include "content/browser/gpu/gpu_data_manager_testing_arrays_and_structs_autogen.h"
#include "content/browser/gpu/gpu_data_manager_testing_exceptions_autogen.h"

namespace gpu {

const GpuControlList::Entry kGpuDataManagerTestingEntries[] = {
    {
        1,  // id
        "GpuDataManagerImplPrivateTest.GpuSideBlocklisting.0",
        base::size(kFeatureListForGpuManagerTestingEntry1),  // features size
        kFeatureListForGpuManagerTestingEntry1,              // features
        0,        // DisabledExtensions size
        nullptr,  // DisabledExtensions
        0,        // DisabledWebGLExtensions size
        nullptr,  // DisabledWebGLExtensions
        0,        // CrBugs size
        nullptr,  // CrBugs
        {
            GpuControlList::kOsAny,  // os_type
            {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
             GpuControlList::kVersionSchemaCommon, nullptr,
             nullptr},                              // os_version
            0x00,                                   // vendor_id
            0,                                      // Devices size
            nullptr,                                // Devices
            GpuControlList::kMultiGpuCategoryNone,  // multi_gpu_category
            GpuControlList::kMultiGpuStyleNone,     // multi_gpu_style
            nullptr,                                // driver info
            nullptr,                                // GL strings
            nullptr,                                // machine model info
            0,                                      // intel_gpu_series size
            nullptr,                                // intel_gpu_series
            {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
             GpuControlList::kVersionSchemaCommon, nullptr,
             nullptr},                  // intel_gpu_generation
            &kMoreForEntry1_572251052,  // more data
        },
        0,        // exceptions count
        nullptr,  // exceptions
    },
    {
        2,  // id
        "GpuDataManagerImplPrivateTest.GpuSideBlocklisting.1",
        base::size(kFeatureListForGpuManagerTestingEntry2),  // features size
        kFeatureListForGpuManagerTestingEntry2,              // features
        0,        // DisabledExtensions size
        nullptr,  // DisabledExtensions
        0,        // DisabledWebGLExtensions size
        nullptr,  // DisabledWebGLExtensions
        0,        // CrBugs size
        nullptr,  // CrBugs
        {
            GpuControlList::kOsAny,  // os_type
            {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
             GpuControlList::kVersionSchemaCommon, nullptr,
             nullptr},                              // os_version
            0x00,                                   // vendor_id
            0,                                      // Devices size
            nullptr,                                // Devices
            GpuControlList::kMultiGpuCategoryNone,  // multi_gpu_category
            GpuControlList::kMultiGpuStyleNone,     // multi_gpu_style
            nullptr,                                // driver info
            &kGLStringsForGpuManagerTestingEntry2,  // GL strings
            nullptr,                                // machine model info
            0,                                      // intel_gpu_series size
            nullptr,                                // intel_gpu_series
            {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
             GpuControlList::kVersionSchemaCommon, nullptr,
             nullptr},                  // intel_gpu_generation
            &kMoreForEntry2_572251052,  // more data
        },
        0,        // exceptions count
        nullptr,  // exceptions
    },
    {
        3,  // id
        "GpuDataManagerImplPrivateTest.GpuSideBlocklistingWebGL.0",
        base::size(kFeatureListForGpuManagerTestingEntry3),  // features size
        kFeatureListForGpuManagerTestingEntry3,              // features
        0,        // DisabledExtensions size
        nullptr,  // DisabledExtensions
        0,        // DisabledWebGLExtensions size
        nullptr,  // DisabledWebGLExtensions
        0,        // CrBugs size
        nullptr,  // CrBugs
        {
            GpuControlList::kOsAny,  // os_type
            {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
             GpuControlList::kVersionSchemaCommon, nullptr,
             nullptr},                              // os_version
            0x00,                                   // vendor_id
            0,                                      // Devices size
            nullptr,                                // Devices
            GpuControlList::kMultiGpuCategoryNone,  // multi_gpu_category
            GpuControlList::kMultiGpuStyleNone,     // multi_gpu_style
            nullptr,                                // driver info
            nullptr,                                // GL strings
            nullptr,                                // machine model info
            0,                                      // intel_gpu_series size
            nullptr,                                // intel_gpu_series
            {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
             GpuControlList::kVersionSchemaCommon, nullptr,
             nullptr},                  // intel_gpu_generation
            &kMoreForEntry3_572251052,  // more data
        },
        0,        // exceptions count
        nullptr,  // exceptions
    },
    {
        4,  // id
        "GpuDataManagerImplPrivateTest.GpuSideBlocklistingWebGL.1",
        base::size(kFeatureListForGpuManagerTestingEntry4),  // features size
        kFeatureListForGpuManagerTestingEntry4,              // features
        0,        // DisabledExtensions size
        nullptr,  // DisabledExtensions
        0,        // DisabledWebGLExtensions size
        nullptr,  // DisabledWebGLExtensions
        0,        // CrBugs size
        nullptr,  // CrBugs
        {
            GpuControlList::kOsAny,  // os_type
            {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
             GpuControlList::kVersionSchemaCommon, nullptr,
             nullptr},                              // os_version
            0x00,                                   // vendor_id
            0,                                      // Devices size
            nullptr,                                // Devices
            GpuControlList::kMultiGpuCategoryNone,  // multi_gpu_category
            GpuControlList::kMultiGpuStyleNone,     // multi_gpu_style
            nullptr,                                // driver info
            &kGLStringsForGpuManagerTestingEntry4,  // GL strings
            nullptr,                                // machine model info
            0,                                      // intel_gpu_series size
            nullptr,                                // intel_gpu_series
            {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
             GpuControlList::kVersionSchemaCommon, nullptr,
             nullptr},                  // intel_gpu_generation
            &kMoreForEntry4_572251052,  // more data
        },
        0,        // exceptions count
        nullptr,  // exceptions
    },
    {
        5,  // id
        "GpuDataManagerImplPrivateTest.GpuSideException",
        base::size(kFeatureListForGpuManagerTestingEntry5),  // features size
        kFeatureListForGpuManagerTestingEntry5,              // features
        0,        // DisabledExtensions size
        nullptr,  // DisabledExtensions
        0,        // DisabledWebGLExtensions size
        nullptr,  // DisabledWebGLExtensions
        0,        // CrBugs size
        nullptr,  // CrBugs
        {
            GpuControlList::kOsAny,  // os_type
            {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
             GpuControlList::kVersionSchemaCommon, nullptr,
             nullptr},                              // os_version
            0x00,                                   // vendor_id
            0,                                      // Devices size
            nullptr,                                // Devices
            GpuControlList::kMultiGpuCategoryNone,  // multi_gpu_category
            GpuControlList::kMultiGpuStyleNone,     // multi_gpu_style
            nullptr,                                // driver info
            nullptr,                                // GL strings
            nullptr,                                // machine model info
            0,                                      // intel_gpu_series size
            nullptr,                                // intel_gpu_series
            {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
             GpuControlList::kVersionSchemaCommon, nullptr,
             nullptr},                  // intel_gpu_generation
            &kMoreForEntry5_572251052,  // more data
        },
        base::size(kExceptionsForEntry5),  // exceptions count
        kExceptionsForEntry5,              // exceptions
    },
    {
        6,  // id
        "GpuDataManagerImplPrivateTest.BlocklistAllFeatures",
        base::size(kFeatureListForGpuManagerTestingEntry6),  // features size
        kFeatureListForGpuManagerTestingEntry6,              // features
        0,        // DisabledExtensions size
        nullptr,  // DisabledExtensions
        0,        // DisabledWebGLExtensions size
        nullptr,  // DisabledWebGLExtensions
        0,        // CrBugs size
        nullptr,  // CrBugs
        {
            GpuControlList::kOsAny,  // os_type
            {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
             GpuControlList::kVersionSchemaCommon, nullptr,
             nullptr},                              // os_version
            0x00,                                   // vendor_id
            0,                                      // Devices size
            nullptr,                                // Devices
            GpuControlList::kMultiGpuCategoryNone,  // multi_gpu_category
            GpuControlList::kMultiGpuStyleNone,     // multi_gpu_style
            nullptr,                                // driver info
            nullptr,                                // GL strings
            nullptr,                                // machine model info
            0,                                      // intel_gpu_series size
            nullptr,                                // intel_gpu_series
            {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
             GpuControlList::kVersionSchemaCommon, nullptr,
             nullptr},                  // intel_gpu_generation
            &kMoreForEntry6_572251052,  // more data
        },
        0,        // exceptions count
        nullptr,  // exceptions
    },
};
const size_t kGpuDataManagerTestingEntryCount = 6;
}  // namespace gpu
