% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_dend.R
\name{dend_expend}
\alias{dend_expend}
\alias{find_dend}
\title{Finds a "good" dendrogram for a dist}
\usage{
dend_expend(x, dist_methods = c("euclidean", "maximum", "manhattan",
  "canberra", "binary", "minkowski"), hclust_methods = c("ward.D", "ward.D2",
  "single", "complete", "average", "mcquitty", "median", "centroid"),
  hclust_fun = hclust, optim_fun = cor_cophenetic, ...)

find_dend(x, ...)
}
\arguments{
\item{x}{A matrix or a data.frame. Can also be a \link{dist} object.}

\item{dist_methods}{A vector of possible \link{dist} methods.}

\item{hclust_methods}{A vector of possible \link{hclust} methods.}

\item{hclust_fun}{By default \link{hclust}.}

\item{optim_fun}{A function that accepts a dend and a dist and returns how the two
are in agreement. Default is \link{cor_cophenetic}.}

\item{...}{options passed from find_dend to dend_expend.}
}
\value{
dend_expend:
A list with three items. The first item is called "dends" and includes
a dendlist with all the possible dendrogram combinations. The second is "dists" and
includes a list with all the possible distance matrix combination.
The third. "performance", is data.frame with three columns: dist_methods, hclust_methods, and optim.
optim is calculated (by default) as the cophenetic correlation (see: \link{cor_cophenetic}) between the distance matrix and
the \link{cophenetic} distance of the hclust object.

find_dend: A dendrogram which is "optimal" based on the output from dend_expend.
}
\description{
There are many options for choosing distance and linkage functions for hclust.
This function goes through various combinations of the two and helps find the one
that is most "similar" to the original distance matrix.
}
\examples{

x <- datasets::mtcars
out <- dend_expend(x, dist_methods = c("euclidean", "manhattan"))
out$performance

dend_expend(dist(x))$performance

best_dend <- find_dend(x, dist_methods = c("euclidean", "manhattan"))
plot(best_dend)


}
