% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifecycle-retired.R
\name{frame_position}
\alias{frame_position}
\title{Find the position or distance of a frame on the evaluation stack}
\usage{
frame_position(frame, from = c("global", "current"))
}
\arguments{
\item{frame}{The environment of a frame. Can be any object with a
\code{\link[=get_env]{get_env()}} method. Note that for frame objects, the position from
the global frame is simply \code{frame$pos}. Alternatively, \code{frame}
can be an integer that represents the position on the stack (and
is thus returned as is if \code{from} is "global".}

\item{from}{Whether to compute distance from the global frame (the
bottom of the evaluation stack), or from the current frame (the
top of the evaluation stack).}
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("soft-deprecated")}

The frame position on the stack can be computed by counting frames
from the global frame (the bottom of the stack, the default) or
from the current frame (the top of the stack).
}
\details{
While this function returns the position of the frame on the
evaluation stack, it can safely be called with intervening frames
as those will be discarded.
}
\section{Life cycle}{


These functions are soft-deprecated and replaced by \code{\link[=trace_back]{trace_back()}}.
}

\examples{
fn <- function() g(environment())
g <- function(env) frame_position(env)

# frame_position() returns the position of the frame on the evaluation stack:
fn()
identity(identity(fn()))

# Note that it trims off intervening calls before counting so you
# can safely nest it within other calls:
g <- function(env) identity(identity(frame_position(env)))
fn()

# You can also ask for the position from the current frame rather
# than the global frame:
fn <- function() g(environment())
g <- function(env) h(env)
h <- function(env) frame_position(env, from = "current")
fn()
}
\keyword{internal}
