/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROJECTLVI_H
#define _SC_PROJECTLVI_H

// sc
#include "ScLvi.h"
#include "Project.h"
class ProjectFoldersWidget;
class RepositoryModel;
class WcModel;

// qt
class QPopupMenu;

/**
 * QListViewItem representing a project.
 */
class ProjectLvi : public ScLvi
{
  typedef ScLvi super;

public:
  ProjectLvi( QListView* parent, RepositoryModel* rmodel, WcModel* wmodel,
    Project* project );

  static void setupActions( ProjectFoldersWidget* parent );
  static QPopupMenu* getMenu();

  // QListViewItem
  QString text( int column ) const;
  int compare( QListViewItem* i, int col, bool ascending ) const;
  bool acceptDrop( const QMimeSource* mime ) const;
  void dropped( QDropEvent* e );
  void setOpen(bool);
  QDragObject* dragObject();

  // ScLvi
  void onItem();
  void contextMenuRequest( const QPoint& pos, int col );
  long getSortPos() const;
  void renamed( const QString& text );

  void enableActions();
  void disableActions();

  Project* getProject();
  void refresh( Project* prj = NULL );
  void removeBookmarks();
  void updateBookmarks();
  void insertBookmarks();

  bool isSelectable( QListViewItem* prev ) const;

  ScLviAccept(ProjectLvi);

private:
  void init();
  void addBookmark( const Project::Item& item );
  QListViewItem* findBookmark( const Project::Item& item );

  Project*         _project;

  RepositoryModel* _rpModel;
  WcModel*         _wcModel;
};

template<typename T> inline ProjectLvi* PrjLvi_cast(T *p)
{
  return dynamic_cast<ProjectLvi*>(p);
}


#endif //  _SC_PROJECTLVI_H

